/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.members.AdInterestDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.adInterests.AdInterest;
import nl.strohalm.cyclos.entities.members.adInterests.AdInterestQuery;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class AdInterestDAOImpl
extends BaseDAOImpl<AdInterest>
implements AdInterestDAO {
    public AdInterestDAOImpl() {
        super(AdInterest.class);
    }

    @Override
    public Iterator<Member> resolveMembersToNotify(Ad ad) {
        HashMap<String, Entity> namedParameters = new HashMap<String, Entity>();
        namedParameters.put("ad", ad);
        namedParameters.put("ownerGroup", ad.getOwner().getGroup());
        StringBuilder hql = new StringBuilder();
        hql.append(" select m ");
        hql.append(" from Member m, Ad ad ");
        hql.append(" where ad = :ad ");
        hql.append("   and :ownerGroup in elements(m.group.canViewAdsOfGroups) ");
        hql.append("   and ad.owner <> m ");
        hql.append("   and exists ( ");
        hql.append("     select ai.id ");
        hql.append("     from AdInterest ai ");
        hql.append("     where ai.owner = m ");
        hql.append("       and ai.type = ad.tradeType ");
        hql.append("       and (ai.category is null or ai.category = ad.category) ");
        hql.append("       and (ai.member is null or ai.member = ad.owner) ");
        hql.append("       and (ai.initialPrice is null or ai.initialPrice <= ad.price) ");
        hql.append("       and (ai.finalPrice is null or ai.finalPrice >= ad.price) ");
        hql.append("       and (ai.currency is null or ai.currency = ad.currency) ");
        hql.append("       and (ai.keywords is null or (upper(ad.title) like upper(concat('%', ai.keywords, '%'))  ");
        hql.append("                                    or (upper(ad.description) like upper(concat('%', ai.keywords, '%')) )) ");
        hql.append("       ) ");
        hql.append("       and (ai.groupFilter is null or exists ( ");
        hql.append("           select gf.id ");
        hql.append("           from GroupFilter gf ");
        hql.append("           where m.group in elements(gf.groups) ");
        hql.append("             and gf = ai.groupFilter ");
        hql.append("          ) ");
        hql.append("       ) ");
        hql.append("    ) ");
        return this.iterate(hql.toString(), namedParameters);
    }

    @Override
    public List<AdInterest> search(AdInterestQuery query) throws DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "ai", fetch);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "ai.owner", query.getOwner());
        return this.list(query, hql.toString(), namedParameters);
    }
}

