/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.members.ContactDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ContactDAOImpl
extends BaseDAOImpl<Contact>
implements ContactDAO {
    private static final Relationship[] FETCH = new Relationship[]{Contact.Relationships.CONTACT};

    public ContactDAOImpl() {
        super(Contact.class);
    }

    @Override
    public List<Contact> listByMember(Member owner) {
        owner = this.getFetchDao().fetch(owner, new Relationship[0]);
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "c");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "c.owner", owner);
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "c.contact.group", ((MemberGroup)owner.getGroup()).getCanViewProfileOfGroups());
        HibernateHelper.appendOrder(hql, "c.contact.user.username");
        return this.list(QueryParameters.ResultType.LIST, hql.toString(), namedParameters, null, FETCH);
    }

    @Override
    public Contact load(Member owner, Member member, Relationship ... fetch) {
        HashMap<String, Member> params = new HashMap<String, Member>();
        params.put("owner", owner);
        params.put("member", member);
        Contact contact = (Contact)this.uniqueResult("from Contact c where c.owner = :owner and c.contact = :member", params);
        if (contact == null) {
            throw new EntityNotFoundException();
        }
        return contact;
    }
}

