/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAO;
import nl.strohalm.cyclos.dao.DeletableDAO;
import nl.strohalm.cyclos.dao.IndexedDAO;
import nl.strohalm.cyclos.dao.InsertableDAO;
import nl.strohalm.cyclos.dao.UpdatableDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.ElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextElementQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.members.RegistrationAgreement;
import nl.strohalm.cyclos.utils.Period;

public interface ElementDAO
extends BaseDAO<Element>,
InsertableDAO<Element>,
UpdatableDAO<Element>,
DeletableDAO<Element>,
IndexedDAO<Element> {
    public void activateMembersOfGroup(MemberGroup var1);

    public void createAgreementForAllMembers(RegistrationAgreement var1, MemberGroup var2);

    public List<? extends Element> fullTextSearch(FullTextElementQuery var1);

    public Map<Long, Integer> getCountPerGroup(Collection<MemberGroup> var1);

    public Map<Long, Integer> getCountPerGroup(Collection<MemberGroup> var1, Calendar var2);

    public Calendar getFirstMemberActivationDate();

    public List<Number[]> getNewMembersCountThroughTheTime(Collection<? extends Group> var1, Period var2) throws DaoException;

    public int getNumberOfMembersInGroupsInPeriod(Collection<? extends Group> var1, Period var2);

    public List<Number[]> getRemovedMembersCountThroughTheTime(Collection<? extends Group> var1, Period var2) throws DaoException;

    public boolean hasValueForField(Member var1, MemberCustomField var2);

    public Iterator<Member> iterateMembers(boolean var1, MemberGroup ... var2);

    public List<Member> listMembersRegisteredBeforeOnGroup(Calendar var1, MemberGroup var2);

    public Member loadByCustomField(MemberCustomField var1, String var2, Relationship[] var3);

    public Element loadByEmail(String var1, Relationship ... var2) throws EntityNotFoundException;

    public void removeChannelsFromMembers(MemberGroup var1, Collection<Channel> var2);

    public List<? extends Element> search(ElementQuery var1) throws DaoException;

    public List<Element> searchAtDate(MemberQuery var1, Calendar var2);

    public List<Element> searchHistoryNew(ElementQuery var1);

    public List<Element> searchHistoryRemoved(ElementQuery var1);
}

