/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.IndexedDAOImpl;
import nl.strohalm.cyclos.dao.JDBCCallback;
import nl.strohalm.cyclos.dao.members.ElementDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.QueryParseException;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.AdminQuery;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.ElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextAdminQuery;
import nl.strohalm.cyclos.entities.members.FullTextElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.FullTextOperatorQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.OperatorQuery;
import nl.strohalm.cyclos.entities.members.RegistrationAgreement;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.BrokerQuery;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.hibernate.HibernateCustomFieldHandler;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.lucene.Filters;
import nl.strohalm.cyclos.utils.lucene.LuceneUtils;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.SQLQuery;

public class ElementDAOImpl
extends IndexedDAOImpl<Element>
implements ElementDAO {
    private static final String[] FIELDS_FULL_TEXT = new String[]{"name", "username", "email", "customValues"};
    private HibernateCustomFieldHandler hibernateCustomFieldHandler;
    private SettingsServiceLocal settingsService;

    public ElementDAOImpl() {
        super(Element.class);
    }

    @Override
    public void activateMembersOfGroup(MemberGroup group) {
        HashMap<String, Comparable<Calendar>> namedParameters = new HashMap<String, Comparable<Calendar>>();
        namedParameters.put("date", Calendar.getInstance());
        namedParameters.put("group", group);
        this.bulkUpdate("update Member set activationDate = :date where group = :group and activationDate is null", namedParameters);
    }

    @Override
    public void createAgreementForAllMembers(final RegistrationAgreement registrationAgreement, final MemberGroup group) {
        this.runNative(new JDBCCallback(){

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                String insert = "insert into registration_agreement_logs (member_id, registration_agreement_id, date) select id, ?, ? from members where group_id = ?";
                jdbc.execute("insert into registration_agreement_logs (member_id, registration_agreement_id, date) select id, ?, ? from members where group_id = ?", registrationAgreement.getId(), Calendar.getInstance(), group.getId());
            }
        });
    }

    @Override
    public List<? extends Element> fullTextSearch(FullTextElementQuery elementQuery) {
        MatchAllDocsQuery query;
        String keywords = StringUtils.trimToNull((String)elementQuery.getKeywords());
        Element.Nature nature = elementQuery.getNature();
        if (nature == null) {
            return Collections.emptyList();
        }
        Analyzer analyzer = elementQuery.getAnalyzer();
        Sort sort = null;
        if (keywords == null) {
            query = new MatchAllDocsQuery();
            sort = new Sort(new SortField("creationDate", 3, true));
        } else {
            try {
                query = keywords == null ? new MatchAllDocsQuery() : this.getQueryParser(analyzer).parse(keywords);
            }
            catch (ParseException e) {
                throw new QueryParseException(e);
            }
        }
        Filters filters = new Filters();
        filters.addTerms("active", elementQuery.getEnabled());
        filters.addTerms("group", elementQuery.getGroups());
        Collection<? extends CustomFieldValue> customValues = elementQuery.getCustomValues();
        if (CollectionUtils.isNotEmpty(customValues)) {
            for (CustomFieldValue customFieldValue : customValues) {
                this.addCustomField(filters, analyzer, customFieldValue);
            }
        }
        if (CollectionUtils.isNotEmpty(elementQuery.getExcludeElements())) {
            Collection<Long> excludeIds = EntityHelper.toIdsAsList(elementQuery.getExcludeElements());
            filters.add(Filters.andNot(Filters.terms("id", excludeIds)));
        }
        if (elementQuery instanceof FullTextMemberQuery) {
            FullTextMemberQuery memberQuery = (FullTextMemberQuery)elementQuery;
            filters.addPeriod("activationDate", memberQuery.getActivationPeriod());
            filters.addTerms("broker", memberQuery.getBroker());
            if (memberQuery.isWithImagesOnly()) {
                filters.addTerms("hasImages", true);
            }
            sort = this.decideSorting(memberQuery);
        } else if (elementQuery instanceof FullTextOperatorQuery) {
            FullTextOperatorQuery operatorQuery = (FullTextOperatorQuery)elementQuery;
            Member member = operatorQuery.getMember();
            if (member == null) {
                return Collections.emptyList();
            }
            filters.addTerms("member", member);
        } else if (elementQuery instanceof FullTextAdminQuery) {
            sort = this.decideSorting(elementQuery);
        }
        return this.list(nature.getElementClass(), elementQuery, (Query)query, filters, sort);
    }

    @Override
    public Map<Long, Integer> getCountPerGroup(Collection<MemberGroup> groups) {
        Map<String, Collection<MemberGroup>> params = Collections.singletonMap("groups", groups);
        StringBuilder hql = new StringBuilder();
        hql.append(" select g.id, count(m.id) ");
        hql.append(" from Member m join m.group g ");
        hql.append(" where g in (:groups) ");
        hql.append(" group by g.id ");
        return this.map(hql.toString(), params);
    }

    @Override
    public Map<Long, Integer> getCountPerGroup(Collection<MemberGroup> groups, Calendar timePoint) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groups", groups);
        params.put("timePoint", timePoint);
        StringBuilder hql = new StringBuilder();
        hql.append(" select g.id, count(m.id) ");
        hql.append(" from GroupHistoryLog l join l.element m join l.group g ");
        hql.append(" where g in (:groups) ");
        hql.append("  and l.period.begin <= :timePoint ");
        hql.append("  and (l.period.end is null or l.period.end > :timePoint)");
        hql.append(" group by g.id");
        return this.map(hql.toString(), params);
    }

    @Override
    public Calendar getFirstMemberActivationDate() {
        String hql = "select min(activationDate) from Member";
        return (Calendar)this.uniqueResult("select min(activationDate) from Member", new HashMap());
    }

    public HibernateCustomFieldHandler getHibernateCustomFieldHandler() {
        return this.hibernateCustomFieldHandler;
    }

    @Override
    public List<Number[]> getNewMembersCountThroughTheTime(Collection<? extends Group> groups, Period period) {
        StringBuilder hql = new StringBuilder("select month(m.creationDate), year(m.creationDate), count(m.id) ");
        hql.append(" from Member m ");
        hql.append(" where 1=1 ");
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        if (groups != null && !groups.isEmpty()) {
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "m.group", groups);
        }
        if (period != null) {
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "m.creationDate", period);
        }
        hql.append(" group by month(m.creationDate), year(m.creationDate) ");
        hql.append(" order by year(m.creationDate), month(m.creationDate) ");
        List results = this.list(hql.toString(), namedParameters);
        Iterator i = results.iterator();
        ArrayList<Number[]> numberList = new ArrayList<Number[]>();
        while (i.hasNext()) {
            Object[] row = (Object[])i.next();
            Integer[] intRow = new Integer[]{(Integer)row[0], (Integer)row[1], (Integer)row[2]};
            numberList.add(intRow);
        }
        return numberList;
    }

    @Override
    public int getNumberOfMembersInGroupsInPeriod(Collection<? extends Group> groups, Period period) {
        StringBuilder hql = new StringBuilder(" select count(m.id) from Member m where 1=1 ");
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(groups) && period != null && period.getEnd() != null) {
            namedParameters.put("endDate", period.getEnd());
            hql.append(" and m.creationDate <= :endDate ");
        } else if (!CollectionUtils.isEmpty(groups) && period != null && period.getEnd() != null && period.getBegin() != null) {
            namedParameters.put("beginDate", period.getBegin());
            namedParameters.put("endDate", period.getEnd());
            namedParameters.put("groups", groups);
            hql.append(" and ( (m.group in (:groups) and m.creationDate < :endDate and not exists ");
            hql.append(" (select gr1.id from GroupRemark gr1 where gr1.subject = m)) or ");
            hql.append(" (m.creationDate < :endDate and exists (select gr.id from GroupRemark gr where gr.subject=m and (gr.oldGroup in ");
            hql.append(" (:groups) or gr.newGroup in (:groups)) and gr.date > :beginDate and gr.date <= :endDate)) or ");
            hql.append(" exists (select gr2.id from GroupRemark gr2 where gr2.subject=m and ");
            hql.append(" gr2.newGroup in (:groups) and gr2.date=(select max(gr3.date) from GroupRemark ");
            hql.append(" gr3 where gr3.subject=m and gr3.date < :beginDate)) or ");
            hql.append(" (m.creationDate <= :endDate and exists (select gr2.id from GroupRemark gr2 where ");
            hql.append(" gr2.subject=m and gr2.oldGroup in (:groups) and gr2.date = (select min(gr3.date) ");
            hql.append(" from GroupRemark gr3 where gr3.subject=m and gr3.date > :endDate))) ");
            hql.append(" ) ");
        } else if (!CollectionUtils.isEmpty(groups)) {
            hql.append(" and m.group in (:groups) ");
            namedParameters.put("groups", groups);
        }
        Number count = (Number)this.uniqueResult(hql.toString(), namedParameters);
        return count.intValue();
    }

    @Override
    public List<Number[]> getRemovedMembersCountThroughTheTime(Collection<? extends Group> groups, Period period) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select month(gr.date), year(gr.date), count(gr.id) ");
        hql.append(" from GroupRemark gr ");
        hql.append(" where 1=1 ");
        hql.append(" and exists ( ");
        hql.append("    select gr.id ");
        hql.append("    from GroupRemark gr ");
        hql.append("    where ");
        hql.append("        gr.subject = e ");
        hql.append("        and gr.newGroup.status = :removed ");
        namedParameters.put("removed", Group.Status.REMOVED);
        if (period != null) {
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "gr.date", period);
        }
        if (groups == null || groups.isEmpty()) {
            return new ArrayList<Number[]>();
        }
        hql.append("        and gr.oldGroup in (:groups) ");
        namedParameters.put("groups", groups);
        hql.append(" \t)");
        hql.append(" and gr.newGroup.status = :removed ");
        hql.append(" group by month(gr.date), year(gr.date) ");
        hql.append(" order by year(gr.date), month(gr.date) ");
        namedParameters.put("removed", Group.Status.REMOVED);
        List results = this.list(hql.toString(), namedParameters);
        Iterator i = results.iterator();
        ArrayList<Number[]> numberList = new ArrayList<Number[]>();
        while (i.hasNext()) {
            Object[] row = (Object[])i.next();
            Integer[] intRow = new Integer[]{(Integer)row[0], (Integer)row[1], (Integer)row[2]};
            numberList.add(intRow);
        }
        return numberList;
    }

    @Override
    public boolean hasValueForField(Member member, MemberCustomField field) {
        HashMap<String, Entity> namedParameters = new HashMap<String, Entity>();
        namedParameters.put("member", member);
        namedParameters.put("field", field);
        StringBuilder hql = new StringBuilder();
        hql.append(" select 1");
        hql.append(" from MemberCustomFieldValue fv");
        hql.append(" where fv.member = :member");
        hql.append("   and fv.field = :field");
        hql.append("   and (fv.possibleValue is not null or (fv.stringValue is not null and length(fv.stringValue) > 0))");
        List list = this.list(QueryParameters.ResultType.LIST, hql.toString(), namedParameters, PageParameters.max(1), new Relationship[0]);
        return !list.isEmpty();
    }

    @Override
    public Iterator<Member> iterateMembers(boolean ordered, MemberGroup ... groups) {
        if (groups == null || groups.length == 0) {
            return Collections.emptyList().iterator();
        }
        Map<String, List<MemberGroup>> parameters = Collections.singletonMap("groups", Arrays.asList(groups));
        return this.iterate("from Member m left join fetch m.user where m.group in (:groups) " + (ordered ? "order by m.name, m.user.username" : ""), parameters);
    }

    @Override
    public List<Member> listMembersRegisteredBeforeOnGroup(Calendar date, MemberGroup group) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select m");
        hql.append(" from GroupHistoryLog log, Member m left join fetch m.user ");
        hql.append(" where log.element = m ");
        hql.append("   and log.element.group = :group ");
        hql.append("   and log.group = :group ");
        hql.append("   and log.period.end is null ");
        hql.append("   and log.period.begin < :date");
        HashMap<String, Comparable<Calendar>> namedParameters = new HashMap<String, Comparable<Calendar>>();
        namedParameters.put("date", date);
        namedParameters.put("group", group);
        return this.list(QueryParameters.ResultType.ITERATOR, hql.toString(), namedParameters, null, Element.Relationships.USER, Element.Relationships.GROUP);
    }

    @Override
    public Member loadByCustomField(MemberCustomField customField, String value, Relationship[] fetch) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select m");
        hql.append(" from MemberCustomFieldValue fv inner join fv.member m inner join m.user u inner join fetch m.group g");
        hql.append(" where g.status <> :removed");
        hql.append(" and fv.field = :field");
        hql.append(" and fv.stringValue = :value");
        namedParameters.put("removed", Group.Status.REMOVED);
        namedParameters.put("field", customField);
        namedParameters.put("value", value);
        Member member = (Member)this.uniqueResult(hql.toString(), namedParameters);
        if (member == null) {
            throw new EntityNotFoundException(Member.class, null, String.format("Custom field used to load: <%1$s, %2$s>", customField.getInternalName(), value));
        }
        return member;
    }

    @Override
    public Element loadByEmail(String email, Relationship ... fetch) throws EntityNotFoundException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(Member.class, "m", Arrays.asList(fetch));
        hql.append(" and m.group.status <> :removed");
        hql.append(" and m.email = :email");
        namedParameters.put("removed", Group.Status.REMOVED);
        namedParameters.put("email", email);
        Element element = (Element)this.uniqueResult(hql.toString(), namedParameters);
        if (element == null) {
            throw new EntityNotFoundException(Element.class);
        }
        return element;
    }

    @Override
    public void removeChannelsFromMembers(MemberGroup group, Collection<Channel> channels) {
        if (CollectionUtils.isNotEmpty(channels)) {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            HashSet channelIds = new HashSet();
            CollectionUtils.addAll(channelIds, (Object[])EntityHelper.toIds(channels));
            parameters.put("channelIds", channelIds);
            parameters.put("groupId", group.getId());
            String statement = " delete from members_channels  where channel_id in (:channelIds)  and member_id in (select id from members where group_id = :groupId) ";
            SQLQuery query = this.getSession().createSQLQuery(" delete from members_channels  where channel_id in (:channelIds)  and member_id in (select id from members where group_id = :groupId) ");
            this.getHibernateQueryHandler().setQueryParameters((org.hibernate.Query)query, parameters);
            query.executeUpdate();
        }
    }

    public List<Element> search(ElementQuery query) {
        Class entityType;
        if (query instanceof AdminQuery) {
            entityType = Administrator.class;
        } else if (query instanceof MemberQuery) {
            entityType = Member.class;
        } else if (query instanceof OperatorQuery) {
            entityType = Operator.class;
        } else {
            throw new IllegalArgumentException("Invalid query parameters: " + query);
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = new StringBuilder();
        if (query instanceof MemberQuery && ((MemberQuery)query).isHasAds()) {
            hql.append(" select distinct e");
            hql.append(" from ").append(entityType.getName()).append(" e inner join e.ads ad ");
        } else {
            hql.append(" select e");
            hql.append(" from ").append(entityType.getName()).append(" e ");
        }
        this.hibernateCustomFieldHandler.appendJoins(hql, "e.customValues", query.getCustomValues());
        HibernateHelper.appendJoinFetch(hql, entityType, "e", fetch);
        hql.append(" where 1=1 ");
        if (query instanceof BrokerQuery) {
            hql.append(" and exists (select 1 from " + BrokerGroup.class.getName() + " bg where bg = e.group) ");
        }
        if (query.getExcludeElements() != null && !query.getExcludeElements().isEmpty()) {
            hql.append(" and e not in (:excludeElements) ");
            namedParameters.put("excludeElements", query.getExcludeElements());
        }
        if (query.isExcludeRemoved()) {
            hql.append(" and e.group.status <> :removedStatus");
            namedParameters.put("removedStatus", Group.Status.REMOVED);
        }
        HibernateHelper.addRightLikeParameterToQuery(hql, namedParameters, "e.user.username", query.getUsername());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "e.name", query.getName());
        HibernateHelper.addRightLikeParameterToQuery(hql, namedParameters, "e.email", query.getEmail());
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "e.group", query.getGroups());
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "e.creationDate", query.getCreationPeriod());
        Boolean enabled = query.getEnabled();
        if (query instanceof AdminQuery) {
            if (enabled != null) {
                Group.Status groupStatus = enabled != false ? Group.Status.NORMAL : Group.Status.REMOVED;
                HibernateHelper.addParameterToQuery(hql, namedParameters, "e.group.status", groupStatus);
            }
        } else if (query instanceof MemberQuery) {
            boolean hasAds;
            Period deactivationPeriod;
            MemberQuery memberQuery = (MemberQuery)query;
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "e.activationDate", memberQuery.getActivationPeriod());
            if (enabled != null) {
                hql.append(" and e.activationDate is " + (enabled != false ? "not" : "") + " null ");
                if (enabled.booleanValue()) {
                    HibernateHelper.addParameterToQuery(hql, namedParameters, "e.group.status", Group.Status.NORMAL);
                }
            }
            if (memberQuery.isWithImagesOnly()) {
                hql.append(" and exists (select mi.id from MemberImage mi where mi.member=e)");
            }
            if ((deactivationPeriod = memberQuery.getDeactivationPeriod()) != null) {
                hql.append(" and exists ( ");
                hql.append("    select gr.id ");
                hql.append("    from GroupRemark gr ");
                hql.append("    where ");
                hql.append("        gr.subject = e ");
                hql.append("        and gr.newGroup.status = :removed ");
                HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "gr.date", deactivationPeriod);
                hql.append(" )");
                namedParameters.put("removed", Group.Status.REMOVED);
            }
            if (hasAds = memberQuery.isHasAds()) {
                hql.append(" and ad.permanent=true or ( ");
                hql.append("     ad.publicationPeriod.begin <= current_date() and ");
                hql.append("     ad.publicationPeriod.end >= current_date() ");
                hql.append(" ) ");
            }
            if (memberQuery.getBroker() != null) {
                HibernateHelper.addParameterToQuery(hql, namedParameters, "e.broker", memberQuery.getBroker());
            }
            if (CollectionUtils.isNotEmpty(memberQuery.getGroupFilters())) {
                hql.append(" and exists (select gf.id from GroupFilter gf where gf in (:groupFilters) and e.group in elements(gf.groups))");
                namedParameters.put("groupFilters", memberQuery.getGroupFilters());
            }
        } else if (query instanceof OperatorQuery) {
            OperatorQuery operatorQuery = (OperatorQuery)query;
            hql.append(" and exists (");
            hql.append("     select o.id from Operator o where o = e and o.member = :member");
            hql.append(" )");
            namedParameters.put("member", operatorQuery.getMember());
        }
        if (query.getViewableGroup() != null) {
            hql.append(" and :mg in elements(e.group.canViewProfileOfGroups)");
            namedParameters.put("mg", query.getViewableGroup());
        }
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getCustomValues());
        if (query.isRandomOrder()) {
            HibernateHelper.appendOrder(hql, "rand()");
        } else if (query.getOrder() != null) {
            switch (query.getOrder()) {
                case USERNAME: {
                    HibernateHelper.appendOrder(hql, "e.user.username");
                    break;
                }
                case NAME: {
                    HibernateHelper.appendOrder(hql, "e.name", "e.id");
                }
            }
        }
        return this.list(query, hql.toString(), namedParameters);
    }

    public Iterator<Member> searchActiveMembers(Collection<Group> toSearch) {
        return this.getHibernateTemplate().iterate(" from " + Member.class.getName() + " m  where m.group in (?)  and exists (select 1 from " + Account.class.getName() + " a where a.member = m) ", toSearch);
    }

    @Override
    public List<Element> searchAtDate(MemberQuery query, Calendar date) {
        StringBuilder hql = HibernateHelper.getInitialQuery(Member.class, "m", query.getFetch());
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        if (query.getBroker() != null) {
            hql.append(" and m.broker = :broker ");
            namedParameters.put("broker", query.getBroker());
        }
        if (date == null) {
            hql.append(" and m.group in (:groups) ");
            namedParameters.put("groups", query.getGroups());
        } else {
            if (!CollectionUtils.isEmpty(query.getGroups())) {
                hql.append(" and ( m.creationDate <= :date ");
                hql.append(" and (m.group in (:groups) and not exists ");
                hql.append(" (select gr1.id from GroupRemark gr1 where gr1.subject=m)) ");
                hql.append(" or exists (select gr2.id from GroupRemark gr2 where gr2.subject=m and ");
                hql.append(" gr2.newGroup in (:groups) and gr2.date= ");
                hql.append(" (select max(gr3.date) from GroupRemark gr3 ");
                hql.append(" where gr3.subject=m and gr3.date <= :date)) ");
                hql.append(" or (m.creationDate <= :date and exists (select gr2.id from ");
                hql.append(" GroupRemark gr2 where gr2.subject=m and gr2.oldGroup in (:groups) ");
                hql.append(" and gr2.date = (select min(gr3.date) from GroupRemark gr3 ");
                hql.append("  where gr3.subject=m and gr3.date > :date)) ))");
                namedParameters.put("groups", query.getGroups());
            } else {
                hql.append(" and m.creationDate <= :date ");
            }
            namedParameters.put("date", date);
        }
        return this.list(QueryParameters.ResultType.ITERATOR, hql.toString(), namedParameters, query.getPageParameters(), new Relationship[0]);
    }

    @Override
    public List<Element> searchHistoryNew(ElementQuery query) {
        Class entityType = query instanceof AdminQuery ? Administrator.class : Member.class;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = new StringBuilder();
        hql.append(" select e");
        hql.append(" from ").append(entityType.getName()).append(" e ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "e.customValues", query.getCustomValues());
        HibernateHelper.appendJoinFetch(hql, entityType, "e", fetch);
        hql.append(" where 1=1");
        HibernateHelper.addRightLikeParameterToQuery(hql, namedParameters, "e.user.username", query.getUsername());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "e.name", query.getName());
        Collection<? extends Group> groups = query.getGroups();
        Boolean enabled = query.getEnabled();
        if (query instanceof AdminQuery) {
            HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "e.creationDate", query.getCreationPeriod());
            if (groups != null && !groups.isEmpty()) {
                HibernateHelper.addInParameterToQuery(hql, namedParameters, "e.group", groups);
            }
            if (enabled != null) {
                Group.Status groupStatus = enabled != false ? Group.Status.NORMAL : Group.Status.REMOVED;
                HibernateHelper.addParameterToQuery(hql, namedParameters, "e.group.status", groupStatus);
            }
        } else if (groups != null && !groups.isEmpty()) {
            hql.append(" and ( ( 1 = 1");
            Period creationPeriod = query.getCreationPeriod();
            if (creationPeriod != null) {
                HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "e.creationDate", creationPeriod);
            }
            hql.append(" and ((not exists ");
            hql.append(" (select gr.id from GroupRemark gr where gr.subject = e) ");
            hql.append(" and e.group in (:groups) )");
            namedParameters.put("groups", groups);
            hql.append("  or exists ( ");
            hql.append("    select gr.id ");
            hql.append("    from GroupRemark gr ");
            hql.append("    where ");
            hql.append("        gr.subject = e ");
            if (groups != null && !groups.isEmpty()) {
                hql.append("        and gr.oldGroup in (:groups) ) ");
            }
            hql.append(")) or ");
            hql.append(" exists ( ");
            hql.append("    select gr.id ");
            hql.append("    from GroupRemark gr ");
            hql.append("    where ");
            hql.append("        gr.subject = e ");
            if (creationPeriod != null) {
                HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "gr.date", creationPeriod);
            }
            if (groups != null && !groups.isEmpty()) {
                hql.append("        and gr.newGroup in (:groups) and gr.oldGroup not in (:groups) ");
                namedParameters.put("groups", groups);
            }
            hql.append("    )");
            hql.append(" ) ");
        } else {
            Period creationPeriod = query.getCreationPeriod();
            if (creationPeriod != null) {
                HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "e.creationDate", creationPeriod);
            }
        }
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getCustomValues());
        HibernateHelper.appendOrder(hql, "e.user.username");
        return this.list(query, hql.toString(), namedParameters);
    }

    @Override
    public List<Element> searchHistoryRemoved(ElementQuery query) {
        Class entityType = query instanceof AdminQuery ? Administrator.class : Member.class;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = new StringBuilder();
        hql.append(" select e");
        hql.append(" from ").append(entityType.getName()).append(" e ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "e.customValues", query.getCustomValues());
        HibernateHelper.appendJoinFetch(hql, entityType, "e", fetch);
        hql.append(" where 1=1");
        if (query instanceof BrokerQuery) {
            hql.append(" and exists (select 1 from " + BrokerGroup.class.getName() + " bg where bg = e.group) ");
        }
        HibernateHelper.addRightLikeParameterToQuery(hql, namedParameters, "e.user.username", query.getUsername());
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "e.name", query.getName());
        MemberQuery memberQuery = (MemberQuery)query;
        Boolean enabled = query.getEnabled();
        if (query instanceof AdminQuery) {
            if (enabled != null) {
                Group.Status groupStatus = enabled != false ? Group.Status.NORMAL : Group.Status.REMOVED;
                HibernateHelper.addParameterToQuery(hql, namedParameters, "e.group.status", groupStatus);
            }
        } else {
            Collection<? extends Group> groups;
            hql.append(" and exists ( ");
            hql.append("    select gr.id ");
            hql.append("    from GroupRemark gr ");
            hql.append("    where ");
            hql.append("        gr.subject = e ");
            Period deactivationPeriod = memberQuery.getDeactivationPeriod();
            if (deactivationPeriod != null) {
                HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "gr.date", deactivationPeriod);
            }
            if ((groups = query.getGroups()) == null || groups.isEmpty()) {
                return new ArrayList<Element>();
            }
            hql.append("     and gr.oldGroup in (:groups) and gr.newGroup not in (:groups) ");
            namedParameters.put("groups", groups);
            hql.append(" \t)");
        }
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getCustomValues());
        HibernateHelper.appendOrder(hql, "e.user.username");
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setHibernateCustomFieldHandler(HibernateCustomFieldHandler hibernateCustomFieldHandler) {
        this.hibernateCustomFieldHandler = hibernateCustomFieldHandler;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    private Sort decideSorting(FullTextElementQuery elementQuery) {
        FullTextMemberQuery memberQuery;
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        LocalSettings.SortOrder memberSortOrder = localSettings.getMemberSortOrder();
        if (elementQuery instanceof FullTextMemberQuery && (memberQuery = (FullTextMemberQuery)elementQuery).getMemberSortOrder() != null) {
            memberSortOrder = memberQuery.getMemberSortOrder();
        }
        Sort sort = memberSortOrder == LocalSettings.SortOrder.CHRONOLOGICAL ? new Sort(new SortField("creationDate", 3, true)) : (elementQuery.getNameDisplay() == LocalSettings.MemberResultDisplay.NAME ? new Sort(new SortField("nameForSort", 3)) : new Sort(new SortField("usernameForSort", 3)));
        return sort;
    }

    private MultiFieldQueryParser getQueryParser(Analyzer analyzer) {
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("name", Float.valueOf(2.0f));
        boosts.put("username", Float.valueOf(1.5f));
        return new MultiFieldQueryParser(LuceneUtils.LUCENE_VERSION, FIELDS_FULL_TEXT, analyzer, boosts);
    }
}

