/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.lucene.AbstractDocumentMapper;
import nl.strohalm.cyclos.utils.lucene.DocumentBuilder;
import org.apache.commons.lang.StringUtils;

public abstract class ElementDocumentMapper<E extends Element>
extends AbstractDocumentMapper<E> {
    protected boolean indexEmail(E element) {
        return StringUtils.isNotEmpty((String)((Element)element).getEmail());
    }

    @Override
    protected void process(DocumentBuilder document, E element) {
        element = (Element)this.fetchDao.fetch(element, Element.Relationships.USER, Element.Relationships.GROUP);
        document.add("name", ((Element)element).getName());
        document.add("username", ((Element)element).getUsername());
        document.add("group", ((Element)element).getGroup());
        document.add("creationDate", ((Element)element).getCreationDate());
        document.add("active", ((Element)element).isActive());
        document.add("nameForSort", ((Element)element).getName(), false);
        document.add("usernameForSort", ((Element)element).getUsername(), false);
        if (this.indexEmail(element)) {
            document.add("email", ((Element)element).getEmail());
        }
        CustomFieldsContainer fieldsContainer = (CustomFieldsContainer)element;
        document.add("customValues", fieldsContainer.getCustomValues());
    }
}

