/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.util.Arrays;
import java.util.List;
import nl.strohalm.cyclos.dao.members.ElementDocumentMapper;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.lucene.DocumentBuilder;
import org.apache.commons.collections.CollectionUtils;

public class MemberDocumentMapper
extends ElementDocumentMapper<Member> {
    public static final List<MemberCustomField.Access> ACCESS_FOR_FILTERING = Arrays.asList(MemberCustomField.Access.WEB_SERVICE, MemberCustomField.Access.ADMIN, MemberCustomField.Access.BROKER, MemberCustomField.Access.MEMBER);

    @Override
    protected boolean indexEmail(Member member) {
        return super.indexEmail(member) && !member.isHideEmail();
    }

    @Override
    protected DocumentBuilder newDocumentBuilder() {
        return new DocumentBuilder(this.fetchDao){

            @Override
            protected boolean includeInKeywordsSearch(String name, CustomFieldValue fieldValue) {
                return MemberDocumentMapper.this.includeInKeywordsSearch((MemberCustomFieldValue)fieldValue);
            }

            @Override
            protected boolean includeInSpecificFiltering(String name, CustomFieldValue fieldValue) {
                return MemberDocumentMapper.this.includeInSpecificFiltering((MemberCustomFieldValue)fieldValue);
            }
        };
    }

    @Override
    protected void process(DocumentBuilder document, Member member) {
        member = this.fetchDao.fetch(member, Member.Relationships.IMAGES);
        boolean hasImages = CollectionUtils.isNotEmpty(member.getImages());
        super.process(document, member);
        document.add("activationDate", member.getActivationDate());
        document.add("broker", member.getBroker());
        document.add("hasImages", hasImages);
    }

    private boolean includeInKeywordsSearch(MemberCustomFieldValue fieldValue) {
        MemberCustomField field = (MemberCustomField)fieldValue.getField();
        return field.getIndexing() != MemberCustomField.Indexing.NONE && !fieldValue.isHidden();
    }

    private boolean includeInSpecificFiltering(MemberCustomFieldValue fieldValue) {
        MemberCustomField field = (MemberCustomField)fieldValue.getField();
        return ACCESS_FOR_FILTERING.contains(field.getMemberSearchAccess());
    }
}

