/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.IndexedDAOImpl;
import nl.strohalm.cyclos.dao.members.MemberRecordDAO;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.QueryParseException;
import nl.strohalm.cyclos.entities.members.records.FullTextMemberRecordQuery;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.entities.members.records.MemberRecordQuery;
import nl.strohalm.cyclos.utils.hibernate.HibernateCustomFieldHandler;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.lucene.Filters;
import nl.strohalm.cyclos.utils.lucene.LuceneUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class MemberRecordDAOImpl
extends IndexedDAOImpl<MemberRecord>
implements MemberRecordDAO {
    private static final String[] FIELDS_FULL_TEXT = new String[]{"customValues", "element.name", "element.username", "element.email", "by.name", "by.username"};
    private HibernateCustomFieldHandler hibernateCustomFieldHandler;

    public MemberRecordDAOImpl() {
        super(MemberRecord.class);
    }

    @Override
    public List<MemberRecord> fullTextSearch(FullTextMemberRecordQuery recordQuery) {
        MatchAllDocsQuery query;
        String keywords = recordQuery.getKeywords();
        Analyzer analyzer = recordQuery.getAnalyzer();
        Sort sort = null;
        if (keywords == null) {
            query = new MatchAllDocsQuery();
            sort = new Sort(new SortField("date", 3, true));
        } else {
            try {
                query = this.getQueryParser(analyzer).parse(keywords);
            }
            catch (ParseException e) {
                throw new QueryParseException(e);
            }
        }
        Filters filters = new Filters();
        filters.addTerms("type", recordQuery.getType());
        filters.addTerms("element", recordQuery.getElement());
        filters.addTerms("element.group", recordQuery.getGroups());
        filters.addTerms("element.broker", recordQuery.getBroker());
        filters.addTerms("by", recordQuery.getBy());
        filters.addPeriod("date", recordQuery.getPeriod());
        if (CollectionUtils.isNotEmpty(recordQuery.getCustomValues())) {
            for (MemberRecordCustomFieldValue fieldValue : recordQuery.getCustomValues()) {
                this.addCustomField(filters, analyzer, fieldValue);
            }
        }
        return this.list(MemberRecord.class, recordQuery, (Query)query, filters, sort);
    }

    @Override
    public List<MemberRecord> search(MemberRecordQuery query) throws DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select mr");
        hql.append(" from ").append(this.getEntityType().getName()).append(" mr ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "mr.customValues", query.getCustomValues());
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "mr", query.getFetch());
        hql.append(" where 1=1");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "mr.type", query.getType());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "mr.element", query.getElement());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "mr.element.group", query.getGroups());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "mr.element.broker", query.getBroker());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "mr.by", query.getBy());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "mr.date", query.getPeriod());
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, query.getCustomValues());
        HibernateHelper.appendOrder(hql, "mr.date desc", "mr.element.name");
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setHibernateCustomFieldHandler(HibernateCustomFieldHandler hibernateCustomFieldHandler) {
        this.hibernateCustomFieldHandler = hibernateCustomFieldHandler;
    }

    private MultiFieldQueryParser getQueryParser(Analyzer analyzer) {
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("customValues", Float.valueOf(2.0f));
        boosts.put("by.name", Float.valueOf(0.5f));
        boosts.put("by.username", Float.valueOf(0.5f));
        return new MultiFieldQueryParser(LuceneUtils.LUCENE_VERSION, FIELDS_FULL_TEXT, analyzer, boosts);
    }
}

