/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomFieldValue;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.utils.lucene.AbstractDocumentMapper;
import nl.strohalm.cyclos.utils.lucene.DocumentBuilder;

public class MemberRecordDocumentMapper
extends AbstractDocumentMapper<MemberRecord> {
    @Override
    protected DocumentBuilder newDocumentBuilder() {
        return new DocumentBuilder(this.fetchDao){

            @Override
            protected boolean includeInSpecificFiltering(String name, CustomFieldValue fieldValue) {
                return MemberRecordDocumentMapper.this.includeInSpecificFiltering((MemberRecordCustomFieldValue)fieldValue);
            }
        };
    }

    @Override
    protected void process(DocumentBuilder document, MemberRecord memberRecord) {
        Element element = this.fetchDao.fetch(memberRecord.getElement(), new Relationship[0]);
        Element createdBy = memberRecord.getBy();
        Element modifiedBy = memberRecord.getModifiedBy();
        document.add("type", memberRecord.getType());
        document.add("date", memberRecord.getDate());
        document.add("element", element);
        document.add("element.name", element.getName());
        document.add("element.username", element.getUsername());
        document.add("element.group", element.getGroup());
        if (element instanceof Member) {
            document.add("element.broker", ((Member)element).getBroker());
        }
        document.add("by", createdBy);
        document.add("by.name", createdBy.getName());
        document.add("by.username", createdBy.getUsername());
        if (modifiedBy != null) {
            document.add("by", modifiedBy);
            document.add("by.name", modifiedBy.getName());
            document.add("by.username", modifiedBy.getUsername());
        }
        document.add("customValues", memberRecord.getCustomValues());
    }

    private boolean includeInSpecificFiltering(MemberRecordCustomFieldValue fieldValue) {
        MemberRecordCustomField field = (MemberRecordCustomField)fieldValue.getField();
        return field.isShowInSearch();
    }
}

