/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.groups.GroupDAO;
import nl.strohalm.cyclos.dao.members.MemberRecordTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.members.records.MemberRecordTypeQuery;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class MemberRecordTypeDAOImpl
extends BaseDAOImpl<MemberRecordType>
implements MemberRecordTypeDAO {
    private GroupDAO groupDao;

    public MemberRecordTypeDAOImpl() {
        super(MemberRecordType.class);
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        int count = 0;
        for (Long id : ids) {
            try {
                MemberRecordType type = (MemberRecordType)this.load(id, (Relationship[])MemberRecordType.Relationships.values());
                for (Group group : this.groupDao.search(new GroupQuery())) {
                    group.getMemberRecordTypes().remove(type);
                    if (group instanceof AdminGroup) {
                        AdminGroup adminGroup = (AdminGroup)group;
                        adminGroup.getViewMemberRecordTypes().remove(type);
                        adminGroup.getCreateMemberRecordTypes().remove(type);
                        adminGroup.getModifyMemberRecordTypes().remove(type);
                        adminGroup.getDeleteMemberRecordTypes().remove(type);
                        adminGroup.getViewAdminRecordTypes().remove(type);
                        adminGroup.getCreateAdminRecordTypes().remove(type);
                        adminGroup.getModifyAdminRecordTypes().remove(type);
                        adminGroup.getDeleteAdminRecordTypes().remove(type);
                        continue;
                    }
                    if (!(group instanceof BrokerGroup)) continue;
                    BrokerGroup brokerGroup = (BrokerGroup)group;
                    brokerGroup.getBrokerMemberRecordTypes().remove(type);
                    brokerGroup.getBrokerCreateMemberRecordTypes().remove(type);
                    brokerGroup.getBrokerModifyMemberRecordTypes().remove(type);
                    brokerGroup.getBrokerDeleteMemberRecordTypes().remove(type);
                }
                for (AdminGroup adminGroup : type.getViewableByAdminGroups()) {
                    adminGroup.getMemberRecordTypes().remove(type);
                }
                for (AdminGroup adminGroup : type.getCreatableByAdminGroups()) {
                    adminGroup.getCreateMemberRecordTypes().remove(type);
                }
                this.getHibernateTemplate().delete((Object)type);
                ++count;
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        if (flush) {
            this.getHibernateTemplate().flush();
        }
        return count;
    }

    @Override
    public List<MemberRecordType> search(MemberRecordTypeQuery query) throws DaoException {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "mrt", query.getFetch());
        if (query.getGroups() != null) {
            if (CollectionUtils.isNotEmpty(query.getGroups())) {
                List<Long> groupIds = Arrays.asList(EntityHelper.toIds(query.getGroups()));
                hql.append(" and exists (select g from Group g where g in elements(mrt.groups) and g.id in (:groupIds)) ");
                namedParameters.put("groupIds", groupIds);
            } else {
                return Collections.emptyList();
            }
        }
        if (query.getViewableByAdminGroup() != null) {
            hql.append(" and exists (select ag.id from AdminGroup ag where ag = :adminGroup and mrt in elements(ag.viewMemberRecordTypes) or mrt in elements(ag.viewAdminRecordTypes)) ");
            namedParameters.put("adminGroup", query.getViewableByAdminGroup());
        }
        if (query.getViewableByBrokerGroup() != null) {
            hql.append(" and exists (select bg.id from BrokerGroup bg where bg = :brokerGroup and mrt in elements(bg.brokerMemberRecordTypes)) ");
            namedParameters.put("brokerGroup", query.getViewableByBrokerGroup());
        }
        if (query.isShowMenuItem()) {
            hql.append(" and mrt.showMenuItem = true");
        }
        return this.list(query, hql.toString(), namedParameters);
    }

    public void setGroupDao(GroupDAO groupDao) {
        this.groupDao = groupDao;
    }
}

