/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.members.MessageCategoryDAO;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.messages.MessageCategoryQuery;
import org.apache.commons.collections.CollectionUtils;

public class MessageCategoryDAOImpl
extends BaseDAOImpl<MessageCategory>
implements MessageCategoryDAO {
    public MessageCategoryDAOImpl() {
        super(MessageCategory.class);
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        int rows = 0;
        for (Long id : ids) {
            try {
                MessageCategory category = (MessageCategory)this.load(id, MessageCategory.Relationships.GROUPS);
                for (SystemGroup systemGroup : category.getGroups()) {
                    systemGroup.getMessageCategories().remove(category);
                }
                this.getHibernateTemplate().delete((Object)category);
                this.getHibernateTemplate().flush();
                ++rows;
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        return rows;
    }

    @Override
    public List<MessageCategory> findAll() {
        return this.list("from " + this.getEntityType().getName() + " c order by c.name", null);
    }

    @Override
    public List<MessageCategory> search(MessageCategoryQuery query) {
        HashMap<String, Group> namedParameters = new HashMap<String, Group>();
        StringBuilder hql = new StringBuilder();
        hql.append("from MessageCategory mc where 1=1 ");
        ArrayList<? extends Group> groups = new ArrayList<Group>();
        if (query.getFromElement() != null) {
            Element fromElement = this.getFetchDao().fetch(query.getFromElement(), Element.Relationships.GROUP);
            Group fromGroup = fromElement.getGroup();
            groups.add(fromGroup);
        }
        if (query.getToElement() != null) {
            Element toElement = this.getFetchDao().fetch(query.getToElement(), Element.Relationships.GROUP);
            Group toGroup = toElement.getGroup();
            groups.add(toGroup);
        }
        if (!CollectionUtils.isEmpty(query.getGroups())) {
            groups.addAll(query.getGroups());
        }
        if (!CollectionUtils.isEmpty(groups)) {
            for (int i = 0; i < groups.size(); ++i) {
                Group group = (Group)groups.get(i);
                hql.append("and exists (select g.id from Group g where mc in elements(g.messageCategories) and g = :group" + i + ") ");
                namedParameters.put("group" + i, group);
            }
        }
        return this.list(hql.toString(), namedParameters);
    }
}

