/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.JDBCCallback;
import nl.strohalm.cyclos.dao.members.MessageDAO;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.messages.MessageBox;
import nl.strohalm.cyclos.entities.members.messages.MessageQuery;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class MessageDAOImpl
extends BaseDAOImpl<Message>
implements MessageDAO {
    public MessageDAOImpl() {
        super(Message.class);
    }

    @Override
    public void assignPendingToSendByBroker(final Message message, final Member broker) {
        if (broker == null) {
            return;
        }
        this.runNative(new JDBCCallback(){

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                StringBuilder sql = new StringBuilder();
                sql.append("insert into messages");
                sql.append(" (date,subject,type,direction,is_read,is_replied,is_html,from_member_id,body,email_sent,to_member_id)");
                sql.append(" select ?,?,?,?,?,?,?,?,?,?,id");
                sql.append(" from members m");
                sql.append(" where m.member_broker_id = ?");
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(message.getDate());
                params.add(message.getSubject());
                params.add(message.getType().getValue());
                params.add(Message.Direction.INCOMING.getValue());
                params.add(false);
                params.add(false);
                params.add(message.isHtml());
                params.add(broker.getId());
                params.add(message.getBody());
                params.add(false);
                params.add(broker.getId());
                jdbc.execute(sql.toString(), params.toArray());
            }
        });
    }

    @Override
    public void assignPendingToSendByGroups(Message message, Collection<MemberGroup> groups) {
        Object[] groupIds = EntityHelper.toIds(groups);
        if (ArrayUtils.isEmpty((Object[])groupIds)) {
            return;
        }
        this.runNative(new JDBCCallback((Long[])groupIds, message){
            final /* synthetic */ Long[] val$groupIds;
            final /* synthetic */ Message val$message;
            {
                this.val$groupIds = longArray;
                this.val$message = message;
            }

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                StringBuilder sql = new StringBuilder();
                sql.append("insert into messages");
                sql.append(" (date,subject,type,direction,is_read,is_replied,is_html,from_member_id,category_id,body,email_sent,to_member_id)");
                sql.append(" select ?,?,?,?,?,?,?,?,?,?,?,id");
                sql.append(" from members m");
                sql.append(" where m.group_id in (");
                Object[] placeHolders = new String[this.val$groupIds.length];
                Arrays.fill(placeHolders, "?");
                sql.append(StringUtils.join((Object[])placeHolders, (String)","));
                sql.append(")");
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(this.val$message.getDate());
                params.add(this.val$message.getSubject());
                params.add(this.val$message.getType().getValue());
                params.add(Message.Direction.INCOMING.getValue());
                params.add(false);
                params.add(false);
                params.add(this.val$message.isHtml());
                params.add(null);
                params.add(this.val$message.getCategory().getId());
                params.add(this.val$message.getBody());
                params.add(false);
                params.addAll(Arrays.asList(this.val$groupIds));
                jdbc.execute(sql.toString(), params.toArray());
            }
        });
    }

    @Override
    public Message nextToSend() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("incoming", Message.Direction.INCOMING);
        params.put("sent", false);
        return (Message)this.uniqueResult("from Message m where m.direction = :incoming and m.emailSent = :sent", params);
    }

    @Override
    public void removeMessagesOnTrashBefore(final Calendar limit) {
        this.runNative(new JDBCCallback(){

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                String deleteMessagesGroups = "delete from messages_to_groups  where exists (      select 1      from messages m      where m.removed_at < ?        and m.id = messages_to_groups.message_id) ";
                jdbc.execute("delete from messages_to_groups  where exists (      select 1      from messages m      where m.removed_at < ?        and m.id = messages_to_groups.message_id) ", limit);
                String deleteMessages = "delete from messages where removed_at < ?";
                jdbc.execute("delete from messages where removed_at < ?", limit);
            }
        });
    }

    @Override
    public List<Message> search(MessageQuery query) {
        MessageBox messageBox;
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "m", query.getFetch());
        Element getter = query.getGetter();
        if (getter instanceof Operator) {
            Operator operator = this.getFetchDao().fetch((Operator)getter, Operator.Relationships.MEMBER);
            getter = operator.getMember();
        }
        if ((messageBox = query.getMessageBox()) == null) {
            messageBox = MessageBox.INBOX;
        }
        switch (messageBox) {
            case SENT: {
                if (getter instanceof Administrator) {
                    hql.append(" and m.fromMember is null ");
                } else if (getter instanceof Member) {
                    hql.append(" and m.fromMember= :getter ");
                }
                if (query.getRootType() == Message.RootType.ADMIN) {
                    hql.append(" and m.toMember is null ");
                } else if (query.getRootType() == Message.RootType.MEMBER) {
                    hql.append(" and m.toMember is not null ");
                } else if (query.getRootType() == Message.RootType.SYSTEM) {
                    HibernateHelper.addInParameterToQuery(hql, namedParameters, "m.type", Message.Type.listByRootType(Message.RootType.SYSTEM));
                }
                hql.append(" and m.direction = :outgoing and m.removedAt is null");
                break;
            }
            case INBOX: {
                if (getter instanceof Administrator) {
                    hql.append(" and m.toMember is null");
                    hql.append(" and (m.category is null or exists (select ag.id from AdminGroup ag where ag = :adminGroup and m.category in elements (ag.messageCategories)))");
                    namedParameters.put("adminGroup", getter.getGroup());
                } else if (getter instanceof Member) {
                    hql.append(" and m.toMember = :getter");
                }
                hql.append(" and m.direction = :incoming and m.removedAt is null");
                HibernateHelper.addInParameterToQuery(hql, namedParameters, "m.type", Message.Type.listByRootType(query.getRootType()));
                break;
            }
            case TRASH: {
                hql.append(" and m.removedAt is not null");
                if (getter instanceof Administrator) {
                    hql.append(" and ( ");
                    hql.append("       (m.direction =:outgoing and m.fromMember is null) or ");
                    hql.append("       (m.direction =:incoming and m.toMember is null) ");
                    hql.append(" ) ");
                    break;
                }
                hql.append(" and ( ");
                hql.append("       (m.direction =:outgoing and m.fromMember = :getter ) or ");
                hql.append("       (m.direction =:incoming and m.toMember = :getter) ");
                hql.append(" ) ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message box: " + (Object)((Object)messageBox));
            }
        }
        namedParameters.put("getter", getter);
        namedParameters.put("incoming", Message.Direction.INCOMING);
        namedParameters.put("outgoing", Message.Direction.OUTGOING);
        Member relatedMember = query.getRelatedMember();
        if (relatedMember != null) {
            hql.append(" and ((m.toMember = :relatedMember and m.direction = :outgoing) or (m.fromMember = :relatedMember and m.direction = :incoming))");
            namedParameters.put("relatedMember", relatedMember);
        }
        if (StringUtils.isNotEmpty((String)query.getKeywords())) {
            hql.append(" and ((upper(m.subject) like :keywords) or (upper(m.body) like :keywords))");
            namedParameters.put("keywords", "%" + query.getKeywords().toUpperCase() + "%");
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "m.read", query.getRead());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "m.category", query.getCategories());
        HibernateHelper.appendOrder(hql, "m.date desc");
        return this.list(query, hql.toString(), namedParameters);
    }
}

