/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.members.PendingMemberDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.PendingMemberQuery;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.hibernate.HibernateCustomFieldHandler;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.lang.StringUtils;

public class PendingMemberDAOImpl
extends BaseDAOImpl<PendingMember>
implements PendingMemberDAO {
    private HibernateCustomFieldHandler hibernateCustomFieldHandler;

    public PendingMemberDAOImpl() {
        super(PendingMember.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBefore(Calendar date) {
        Map<String, Calendar> namedParameters = Collections.singletonMap("date", date);
        Iterator iterator = this.iterate("from " + this.getEntityType().getName() + " pm where pm.creationDate < :date", namedParameters);
        try {
            while (iterator.hasNext()) {
                this.getHibernateTemplate().delete(iterator.next());
            }
        }
        finally {
            DataIteratorHelper.close(iterator);
        }
    }

    @Override
    public boolean emailExists(PendingMember pendingMember, String email) {
        Number count;
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select count(*)");
        hql.append(" from PendingMember pm");
        hql.append(" where 1 = 1");
        HibernateHelper.addParameterToQuery(hql, namedParameters, "upper(pm.email)", email.toUpperCase());
        if (pendingMember != null && pendingMember.isPersistent()) {
            HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "pm", "<>", pendingMember);
        }
        return (count = (Number)this.uniqueResult(hql.toString(), namedParameters)) != null && count.intValue() > 0;
    }

    @Override
    public PendingMember loadByKey(String key, Relationship ... fetch) {
        return this.loadBy("validationKey", key, fetch);
    }

    @Override
    public PendingMember loadByUsername(String username, Relationship ... fetch) {
        return this.loadBy("username", username, fetch);
    }

    @Override
    public List<PendingMember> search(PendingMemberQuery params) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select pm");
        hql.append(" from ").append(this.getEntityType().getName()).append(" pm ");
        this.hibernateCustomFieldHandler.appendJoins(hql, "pm.customValues", params.getCustomValues());
        HibernateHelper.appendJoinFetch(hql, this.getEntityType(), "pm", params.getFetch());
        hql.append(" where 1=1");
        HibernateHelper.addLikeParameterToQuery(hql, namedParameters, "pm.name", params.getName());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "pm.broker", params.getBroker());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "pm.creationDate", params.getCreationPeriod());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "pm.memberGroup", params.getGroups());
        this.hibernateCustomFieldHandler.appendConditions(hql, namedParameters, params.getCustomValues());
        HibernateHelper.appendOrder(hql, "pm.creationDate desc");
        return this.list(params, hql.toString(), namedParameters);
    }

    public void setHibernateCustomFieldHandler(HibernateCustomFieldHandler hibernateCustomFieldHandler) {
        this.hibernateCustomFieldHandler = hibernateCustomFieldHandler;
    }

    private PendingMember loadBy(String property, String value, Relationship[] fetch) {
        Map<String, String> params = Collections.singletonMap("value", value);
        PendingMember pendingMember = (PendingMember)this.uniqueResult("from PendingMember pm where pm." + property + " = :value", params);
        if (pendingMember == null) {
            throw new EntityNotFoundException(PendingMember.class);
        }
        return this.getFetchDao().fetch(pendingMember, fetch);
    }
}

