/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.members.ReferenceDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentAwaitingFeedbackDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.GeneralReference;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PaymentsAwaitingFeedbackQuery;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.ReferenceQuery;
import nl.strohalm.cyclos.entities.members.TransactionFeedback;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.IteratorListImpl;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.ScrollableResultsIterator;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.query.PageImpl;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class ReferenceDAOImpl
extends BaseDAOImpl<Reference>
implements ReferenceDAO {
    public ReferenceDAOImpl() {
        super(Reference.class);
    }

    @Override
    public Map<Reference.Level, Integer> countGivenReferencesByLevel(Reference.Nature nature, Collection<MemberGroup> memberGroups) {
        return this.countReferencesByLevel(nature, null, null, memberGroups, false);
    }

    @Override
    public Map<Reference.Level, Integer> countReferencesByLevel(Reference.Nature nature, Period period, Member member, boolean received) {
        return this.countReferencesByLevel(nature, period, member, null, received);
    }

    public Map<Reference.Level, Integer> countReferencesByLevel(Reference.Nature nature, Period period, Member member, Collection<MemberGroup> memberGroups, boolean received) {
        EnumMap<Reference.Level, Integer> countGivenReferences = new EnumMap<Reference.Level, Integer>(Reference.Level.class);
        for (Reference.Level level : Reference.Level.values()) {
            countGivenReferences.put(level, 0);
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Class<? extends Reference> type = this.typeForNature(nature);
        StringBuilder hql = new StringBuilder("select r.level, count(r.id) from ").append(type.getName()).append(" r where 1=1 ");
        HibernateHelper.addParameterToQuery(hql, namedParameters, received ? "r.to" : "r.from", member);
        if (memberGroups != null && !memberGroups.isEmpty()) {
            hql.append(" and " + (received ? "r.to" : "r.from") + ".group in (:memberGroups) ");
            namedParameters.put("memberGroups", memberGroups);
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "r.date", period);
        hql.append(" group by r.level order by r.level");
        List rows = this.list(hql.toString(), namedParameters);
        for (Object[] row : rows) {
            countGivenReferences.put((Reference.Level)row[0], (Integer)row[1]);
        }
        return countGivenReferences;
    }

    @Override
    public List<? extends Reference> search(ReferenceQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        Reference.Nature nature = query.getNature();
        Class<? extends Reference> type = this.typeForNature(nature);
        StringBuilder hql = HibernateHelper.getInitialQuery(type, "r", fetch);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "r.from", query.getFrom());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "r.to", query.getTo());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "r.date", query.getPeriod());
        if (nature == Reference.Nature.TRANSACTION) {
            HibernateHelper.addParameterToQuery(hql, namedParameters, "r.transfer", query.getTransfer());
            HibernateHelper.addParameterToQuery(hql, namedParameters, "r.scheduledPayment", query.getScheduledPayment());
        }
        if (query.getGroups() != null) {
            hql.append(" and (r.from.group in (:groups) or r.to.group in (:groups)) ");
            namedParameters.put("groups", query.getGroups());
        }
        HibernateHelper.appendOrder(hql, "r.id desc");
        return this.list(query, hql.toString(), namedParameters);
    }

    @Override
    public List<PaymentAwaitingFeedbackDTO> searchPaymentsAwaitingFeedback(PaymentsAwaitingFeedbackQuery query) {
        QueryParameters.ResultType resultType = query.getResultType();
        PageParameters pageParameters = query.getPageParameters();
        boolean countOnly = resultType == QueryParameters.ResultType.PAGE && pageParameters != null && pageParameters.getMaxResults() == 0;
        Member member = query.getMember();
        Boolean expired = query.getExpired();
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        if (countOnly) {
            sql.append(" count(*) as row_count");
        } else {
            sql.append(" * ");
        }
        sql.append(" from ( ");
        sql.append(" select t.id, t.type_id as transferTypeId, false as scheduled, t.date, t.amount, tm.id as memberId, tm.name as memberName, ta.owner_name as memberUsername");
        sql.append(" from transfers t inner join transfer_types tt on t.type_id = tt.id inner join accounts ta on t.to_account_id = ta.id inner join members tm on ta.member_id = tm.id");
        if (member != null) {
            sql.append(" inner join accounts a on t.from_account_id = a.id");
        }
        sql.append(" left join refs tf on tf.transfer_id = t.id");
        sql.append(" where tt.requires_feedback = true");
        sql.append(" and t.date >= tt.feedback_enabled_since");
        sql.append(" and t.parent_id is null");
        sql.append(" and t.chargeback_of_id is null");
        sql.append(" and t.scheduled_payment_id is null");
        sql.append(" and t.process_date is not null");
        if (expired != null) {
            sql.append(" and t.feedback_deadline " + (expired != false ? "<" : ">=") + " now()");
        }
        sql.append(" and tf.id is null");
        if (member != null) {
            sql.append(" and a.member_id = :memberId");
        }
        sql.append(" union ");
        sql.append(" select sp.id, sp.type_id, true, sp.date, sp.amount, tm.id, tm.name, ta.owner_name");
        sql.append(" from scheduled_payments sp inner join transfer_types tt on sp.type_id = tt.id inner join accounts ta on sp.to_account_id = ta.id inner join members tm on ta.member_id = tm.id");
        if (member != null) {
            sql.append(" inner join accounts a on sp.from_account_id = a.id");
        }
        sql.append(" left join refs tf on tf.scheduled_payment_id = sp.id");
        sql.append(" where tt.requires_feedback = true");
        if (expired != null) {
            sql.append(" and sp.feedback_deadline " + (expired != false ? "<" : ">=") + " now()");
        }
        sql.append(" and sp.date >= tt.feedback_enabled_since");
        sql.append(" and tf.id is null");
        if (member != null) {
            sql.append(" and a.member_id = :memberId");
        }
        sql.append(") as awaiting ");
        if (!countOnly) {
            sql.append("order by date");
        }
        SQLQuery sqlQuery = this.getSession().createSQLQuery(sql.toString());
        if (member != null) {
            sqlQuery.setLong("memberId", member.getId().longValue());
        }
        if (countOnly) {
            sqlQuery.addScalar("row_count", (Type)StandardBasicTypes.INTEGER);
            int count = ((Number)sqlQuery.uniqueResult()).intValue();
            return new PageImpl<PaymentAwaitingFeedbackDTO>(pageParameters, count, Collections.emptyList());
        }
        sqlQuery.addScalar("id", (Type)StandardBasicTypes.LONG);
        sqlQuery.addScalar("transferTypeId", (Type)StandardBasicTypes.LONG);
        sqlQuery.addScalar("scheduled", (Type)StandardBasicTypes.BOOLEAN);
        sqlQuery.addScalar("date", (Type)StandardBasicTypes.CALENDAR);
        sqlQuery.addScalar("amount", (Type)StandardBasicTypes.BIG_DECIMAL);
        sqlQuery.addScalar("memberId", (Type)StandardBasicTypes.LONG);
        sqlQuery.addScalar("memberName", (Type)StandardBasicTypes.STRING);
        sqlQuery.addScalar("memberUsername", (Type)StandardBasicTypes.STRING);
        this.getHibernateQueryHandler().applyPageParameters(pageParameters, (Query)sqlQuery);
        ScrollableResultsIterator<PaymentAwaitingFeedbackDTO> iterator = new ScrollableResultsIterator<PaymentAwaitingFeedbackDTO>((Query)sqlQuery, new Transformer<Object[], PaymentAwaitingFeedbackDTO>(){

            @Override
            public PaymentAwaitingFeedbackDTO transform(Object[] input) {
                PaymentAwaitingFeedbackDTO dto = new PaymentAwaitingFeedbackDTO();
                dto.setId((Long)input[0]);
                dto.setTransferTypeId((Long)input[1]);
                dto.setScheduled(Boolean.TRUE.equals(input[2]));
                dto.setDate((Calendar)input[3]);
                dto.setAmount((BigDecimal)input[4]);
                dto.setMemberId((Long)input[5]);
                dto.setMemberName((String)input[6]);
                dto.setMemberUsername((String)input[7]);
                TransferType transferType = (TransferType)ReferenceDAOImpl.this.getSession().load(TransferType.class, (Serializable)dto.getTransferTypeId());
                dto.setCurrency(ReferenceDAOImpl.this.getFetchDao().fetch(transferType.getCurrency(), new Relationship[0]));
                return dto;
            }
        });
        if (resultType == QueryParameters.ResultType.ITERATOR) {
            return new IteratorListImpl<PaymentAwaitingFeedbackDTO>(iterator);
        }
        ArrayList<PaymentAwaitingFeedbackDTO> list = new ArrayList<PaymentAwaitingFeedbackDTO>();
        CollectionUtils.addAll(list, iterator);
        DataIteratorHelper.close(iterator);
        if (resultType == QueryParameters.ResultType.PAGE) {
            query.setPageForCount();
            int totalCount = PageHelper.getTotalCount(this.searchPaymentsAwaitingFeedback(query));
            return new PageImpl<PaymentAwaitingFeedbackDTO>(pageParameters, totalCount, list);
        }
        return list;
    }

    private Class<? extends Reference> typeForNature(Reference.Nature nature) {
        Class type = nature == Reference.Nature.TRANSACTION ? TransactionFeedback.class : (nature == Reference.Nature.GENERAL ? GeneralReference.class : Reference.class);
        return type;
    }
}

