/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members;

import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.members.ReferenceHistoryDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.ReferenceHistoryLog;
import nl.strohalm.cyclos.entities.members.ReferenceHistoryLogQuery;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class ReferenceHistoryDAOImpl
extends BaseDAOImpl<ReferenceHistoryLog>
implements ReferenceHistoryDAO {
    public ReferenceHistoryDAOImpl() {
        super(ReferenceHistoryLog.class);
    }

    @Override
    public Map<Reference.Level, Integer> countReferencesHistoryByLevel(Member member, Collection<MemberGroup> memberGroups, Period date, boolean received) {
        EnumMap<Reference.Level, Integer> countGivenReferences = new EnumMap<Reference.Level, Integer>(Reference.Level.class);
        for (Reference.Level level : Reference.Level.values()) {
            countGivenReferences.put(level, 0);
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select rh.level, count(rh.id) from ReferenceHistoryLog rh where 1=1 ");
        HibernateHelper.addParameterToQuery(hql, namedParameters, received ? "rh.to" : "rh.from", member);
        if (memberGroups != null && !memberGroups.isEmpty()) {
            hql.append(" and " + (received ? "rh.to" : "rh.from") + ".group in (:memberGroups) ");
            namedParameters.put("memberGroups", memberGroups);
        }
        if (date != null) {
            Calendar end;
            Calendar begin = DateHelper.truncate(date.getBegin());
            if (begin != null) {
                HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "rh.period.begin", ">=", begin);
            }
            if ((end = DateHelper.truncate(date.getEnd())) != null) {
                hql.append(" and rh.period.begin < :endNextDay and (rh.period.end is null or rh.period.end >= :end)");
                namedParameters.put("end", end);
                namedParameters.put("endNextDay", DateHelper.truncateNextDay(end));
            }
        }
        hql.append(" group by rh.level order by rh.level");
        List rows = this.list(hql.toString(), namedParameters);
        for (Object[] row : rows) {
            countGivenReferences.put((Reference.Level)row[0], (Integer)row[1]);
        }
        return countGivenReferences;
    }

    @Override
    public Map<Reference.Level, Integer> countReferencesHistoryByLevel(Member member, Period date, boolean received) {
        return this.countReferencesHistoryByLevel(member, null, date, received);
    }

    @Override
    public ReferenceHistoryLog getOpenReferenceHistoryLog(ReferenceHistoryLogQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        Set<Relationship> fetch = query.getFetch();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "rhl", fetch);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "rhl.from", query.getFrom());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "rhl.to", query.getTo());
        hql.append(" and rhl.period.end is null ");
        return (ReferenceHistoryLog)this.uniqueResult(hql.toString(), namedParameters);
    }
}

