/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members.brokerings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.members.brokerings.BrokerCommissionContractDAO;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContractQuery;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class BrokerCommissionContractDAOImpl
extends BaseDAOImpl<BrokerCommissionContract>
implements BrokerCommissionContractDAO {
    public BrokerCommissionContractDAOImpl() {
        super(BrokerCommissionContract.class);
    }

    @Override
    public boolean isConflictingContract(BrokerCommissionContract brokerCommissionContract) {
        StringBuilder hql = new StringBuilder("from BrokerCommissionContract oc where 1=1 ");
        if (brokerCommissionContract.isPersistent()) {
            hql.append(" and oc != :contract ");
        }
        hql.append(" and oc.brokering = :brokering ");
        hql.append(" and oc.brokerCommission = :brokerCommission ");
        hql.append(" and (oc.period.end is null or oc.period.end >= :startDate) ");
        hql.append(" and oc.status in (:statusList) ");
        ArrayList<BrokerCommissionContract.Status> statusList = new ArrayList<BrokerCommissionContract.Status>();
        statusList.add(BrokerCommissionContract.Status.PENDING);
        statusList.add(BrokerCommissionContract.Status.ACTIVE);
        HashMap<String, Cloneable> namedParameters = new HashMap<String, Cloneable>();
        namedParameters.put("contract", brokerCommissionContract);
        namedParameters.put("brokering", brokerCommissionContract.getBrokering());
        namedParameters.put("brokerCommission", brokerCommissionContract.getBrokerCommission());
        namedParameters.put("startDate", brokerCommissionContract.getPeriod().getBegin());
        namedParameters.put("statusList", statusList);
        List contracts = this.list(hql.toString(), namedParameters);
        return CollectionUtils.isNotEmpty(contracts);
    }

    @Override
    public List<BrokerCommissionContract> search(BrokerCommissionContractQuery query) {
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "bcc", query.getFetch());
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        HibernateHelper.addParameterToQuery(hql, namedParameters, "bcc.brokering.broker", query.getBroker());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "bcc.brokering.brokered", query.getMember());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "bcc.brokerCommission", query.getBrokerCommission());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "bcc.period.begin", query.getStartPeriod());
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "bcc.period.end", query.getEndPeriod());
        HibernateHelper.addInParameterToQuery(hql, namedParameters, "bcc.status", query.getStatusList());
        if (CollectionUtils.isNotEmpty(query.getManagedMemberGroups())) {
            hql.append(" and (bcc.brokering.broker.group in (:groups_) or bcc.brokering.brokered.group in (:groups_))");
            namedParameters.put("groups_", query.getManagedMemberGroups());
        }
        HibernateHelper.appendOrder(hql, "bcc.brokerCommission.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

