/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members.brokerings;

import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.members.brokerings.BrokeringCommissionStatusDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.members.brokerings.BrokeringCommissionStatus;
import nl.strohalm.cyclos.entities.members.brokerings.BrokeringCommissionStatusQuery;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class BrokeringCommissionStatusDAOImpl
extends BaseDAOImpl<BrokeringCommissionStatus>
implements BrokeringCommissionStatusDAO {
    public BrokeringCommissionStatusDAOImpl() {
        super(BrokeringCommissionStatus.class);
    }

    @Override
    public void expireBrokeringCommissionStatus(Calendar date) {
        StringBuilder hql = new StringBuilder();
        hql.append(" update BrokeringCommissionStatus bcs ");
        hql.append(" set bcs.period.end = bcs.expiryDate ");
        hql.append(" where bcs.period.end is null ");
        hql.append("   and bcs.expiryDate is not null ");
        hql.append("   and bcs.expiryDate <= :date ");
        HashMap<String, Calendar> namedParameters = new HashMap<String, Calendar>();
        namedParameters.put("date", date);
        this.bulkUpdate(hql.toString(), namedParameters);
    }

    @Override
    public BrokeringCommissionStatus load(Brokering brokering, BrokerCommission brokerCommission, Relationship ... fetch) {
        List<Relationship> fetchList = Arrays.asList(fetch);
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "bcs", fetchList);
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        HibernateHelper.addParameterToQuery(hql, namedParameters, "bcs.brokering", brokering);
        HibernateHelper.addParameterToQuery(hql, namedParameters, "bcs.brokerCommission", brokerCommission);
        HibernateHelper.appendOrder(hql, "bcs.brokerCommission.name");
        List list = this.list(hql.toString(), namedParameters);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return (BrokeringCommissionStatus)list.iterator().next();
    }

    @Override
    public List<BrokeringCommissionStatus> search(BrokeringCommissionStatusQuery query) {
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "bcs", query.getFetch());
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        HibernateHelper.addParameterToQuery(hql, namedParameters, "bcs.brokering.broker", query.getBroker());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "bcs.brokering", query.getBrokering());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "bcs.brokerCommission", query.getBrokerCommission());
        if (query.isOnlyActive()) {
            hql.append(" and bcs.period.end is null ");
        }
        if (query.isAlreadyCharged()) {
            hql.append(" and bcs.total.count > 0 ");
        }
        HibernateHelper.appendOrder(hql, "bcs.brokerCommission.name");
        return this.list(hql.toString(), namedParameters);
    }
}

