/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.members.imports;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.members.imports.ImportedMemberDAO;
import nl.strohalm.cyclos.entities.members.imports.ImportedMember;
import nl.strohalm.cyclos.entities.members.imports.ImportedMemberQuery;
import nl.strohalm.cyclos.entities.members.imports.MemberImport;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.lang.StringUtils;

public class ImportedMemberDAOImpl
extends BaseDAOImpl<ImportedMember>
implements ImportedMemberDAO {
    public ImportedMemberDAOImpl() {
        super(ImportedMember.class);
    }

    @Override
    public TransactionSummaryVO getTransactions(MemberImport memberImport, boolean credits) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select new nl.strohalm.cyclos.services.transactions.NegativeAllowedTransactionSummaryVO(count(*), sum(m.initialBalance))");
        hql.append(" from " + this.getEntityType().getName() + " m");
        hql.append(" where m.status = :success");
        hql.append("   and m.import = :import");
        hql.append("   and m.initialBalance" + (credits ? ">=" : "<") + " :zero");
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("success", ImportedMember.Status.SUCCESS);
        namedParameters.put("import", memberImport);
        namedParameters.put("zero", BigDecimal.ZERO);
        return (TransactionSummaryVO)this.uniqueResult(hql.toString(), namedParameters);
    }

    @Override
    public List<ImportedMember> search(ImportedMemberQuery params) {
        MemberImport memberImport = params.getMemberImport();
        if (memberImport == null || memberImport.isTransient()) {
            return Collections.emptyList();
        }
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "m", params.getFetch());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "m.import", memberImport);
        ImportedMemberQuery.Status status = params.getStatus();
        if (status != null && status != ImportedMemberQuery.Status.ALL) {
            String operator = status == ImportedMemberQuery.Status.ERROR ? "<>" : "=";
            HibernateHelper.addParameterToQueryOperator(hql, namedParameters, "m.status", operator, ImportedMember.Status.SUCCESS);
        }
        HibernateHelper.addParameterToQuery(hql, namedParameters, "m.lineNumber", params.getLineNumber());
        String nameOrUsername = StringUtils.trimToNull((String)params.getNameOrUsername());
        if (nameOrUsername != null) {
            hql.append(" and (upper(m.name) like :nameOrUsername or upper(m.username) like :nameOrUsername)");
            namedParameters.put("nameOrUsername", "%" + nameOrUsername.toUpperCase() + "%");
        }
        HibernateHelper.appendOrder(hql, "m.lineNumber");
        return this.list(params, hql.toString(), namedParameters);
    }
}

