/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.services;

import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.services.ServiceClientDAO;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.services.ServiceClientQuery;
import nl.strohalm.cyclos.utils.InternetAddressHelper;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;

public class ServiceClientDAOImpl
extends BaseDAOImpl<ServiceClient>
implements ServiceClientDAO {
    public ServiceClientDAOImpl() {
        super(ServiceClient.class);
    }

    @Override
    public List<ServiceClient> search(ServiceClientQuery query) {
        String password;
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        StringBuilder hql = HibernateHelper.getInitialQuery(ServiceClient.class, "c", query.getFetch());
        String address = query.getAddress();
        if (InternetAddressHelper.isSimpleIp(address)) {
            hql.append(" and :address between c.addressBegin and c.addressEnd");
            namedParameters.put("address", InternetAddressHelper.padAddress(address));
        }
        namedParameters.put("blank", "");
        String username = query.getUsername();
        if (username != null) {
            if (username.length() == 0) {
                hql.append(" and (c.username is null or c.username = :blank)");
            } else {
                hql.append(" and c.username = :username");
                namedParameters.put("username", username);
            }
        }
        if ((password = query.getPassword()) != null) {
            if (password.length() == 0) {
                hql.append(" and (c.password is null or c.password = :blank)");
            } else {
                hql.append(" and c.password = :password");
                namedParameters.put("password", password);
            }
        }
        HibernateHelper.appendOrder(hql, "c.name");
        return this.list(query, hql.toString(), namedParameters);
    }
}

