/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.settings;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.settings.SettingDAO;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.setup.CreateBasicData;
import nl.strohalm.cyclos.setup.Setup;

public class SettingDAOImpl
extends BaseDAOImpl<Setting>
implements SettingDAO {
    private Properties cyclosProperties;

    public SettingDAOImpl() {
        super(Setting.class);
    }

    @Override
    public void deleteByType(Setting.Type ... types) {
        if (types == null || types.length == 0) {
            return;
        }
        this.bulkUpdate("delete from " + this.getEntityType().getName() + " e where e.type in (:types)", Collections.singletonMap("types", Arrays.asList(types)));
    }

    @Override
    public void importNew(Locale locale) {
        CreateBasicData.createSettings(this.getSession(), Setup.getResourceBundle(locale), locale, this.cyclosProperties);
    }

    @Override
    public List<Setting> listByType(Setting.Type type) {
        Map<String, Setting.Type> params = Collections.singletonMap("type", type);
        return this.list("from " + this.getEntityType().getName() + " e where e.type = :type", params);
    }

    @Override
    public Setting load(Setting.Type type, String name) throws EntityNotFoundException, DaoException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("name", name);
        Setting setting = (Setting)this.uniqueResult("from " + this.getEntityType().getName() + " e where e.type = :type and e.name = :name", params);
        if (setting == null) {
            throw new EntityNotFoundException(this.getEntityType());
        }
        return setting;
    }

    public void setCyclosProperties(Properties cyclosProperties) {
        this.cyclosProperties = cyclosProperties;
    }
}

