/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.sms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.sms.SmsLogDAO;
import nl.strohalm.cyclos.dao.sms.SmsLogReportTotal;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.sms.SmsLog;
import nl.strohalm.cyclos.entities.sms.SmsLogQuery;
import nl.strohalm.cyclos.entities.sms.SmsLogReportQuery;
import nl.strohalm.cyclos.entities.sms.SmsLogStatus;
import nl.strohalm.cyclos.entities.sms.SmsLogType;
import nl.strohalm.cyclos.entities.sms.SmsMailingType;
import nl.strohalm.cyclos.entities.sms.SmsType;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class SmsLogDAOImpl
extends BaseDAOImpl<SmsLog>
implements SmsLogDAO {
    public SmsLogDAOImpl() {
        super(SmsLog.class);
    }

    @Override
    public List<SmsLogReportTotal> getReportTotals(SmsLogQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        String typeStr = "case when m is not null then 'MAILING' when l.smsType.id is not null then 'SMS_OPERATION' else 'NOTIFICATION' end";
        String statusStr = "case when l.errorType is null then 'DELIVERED' else 'ERROR' end";
        hql.append("select new ").append(SmsLogReportTotal.class.getName()).append('(');
        hql.append("case when m is not null then 'MAILING' when l.smsType.id is not null then 'SMS_OPERATION' else 'NOTIFICATION' end").append(',').append("case when l.errorType is null then 'DELIVERED' else 'ERROR' end").append(", count(l.id))");
        this.processQuery(query, hql, namedParameters, false);
        hql.append(" group by ").append("case when m is not null then 'MAILING' when l.smsType.id is not null then 'SMS_OPERATION' else 'NOTIFICATION' end").append(',').append("case when l.errorType is null then 'DELIVERED' else 'ERROR' end");
        return this.list(hql.toString(), namedParameters);
    }

    @Override
    public List<SmsLog> search(SmsLogQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder();
        hql.append(" select l");
        this.processQuery(query, hql, namedParameters, true);
        HibernateHelper.appendOrder(hql, "l.date desc");
        return this.list(query, hql.toString(), namedParameters);
    }

    private void processQuery(SmsLogQuery query, StringBuilder hql, Map<String, Object> namedParameters, boolean addFetch) {
        SmsLogType type;
        SmsLogStatus queryStatus;
        hql.append(" from SmsLog l left join l.smsMailing m left join m.by b");
        if (addFetch) {
            HibernateHelper.appendJoinFetch(hql, this.entityClass, "l", query.getFetch());
        }
        hql.append(" where 1=1");
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "l.date", query.getPeriod());
        Member member = query.getMember();
        if (member != null) {
            hql.append(" and (l.chargedMember = :member or l.targetMember = :member)");
            namedParameters.put("member", member);
        }
        if ((queryStatus = query.getStatus()) != null) {
            hql.append(" and l.errorType is ");
            if (queryStatus == SmsLogStatus.ERROR) {
                hql.append("not ");
            }
            hql.append("null");
        }
        if ((type = query.getType()) != null) {
            switch (type) {
                case MAILING: {
                    Collection<SmsMailingType> mailingTypes = null;
                    if (query instanceof SmsLogReportQuery) {
                        mailingTypes = ((SmsLogReportQuery)query).getMailingTypes();
                    }
                    if (CollectionUtils.isEmpty(mailingTypes)) {
                        hql.append(" and l.smsMailing is not null");
                        break;
                    }
                    namedParameters.put("admin", Element.Nature.ADMIN.getValue());
                    StringBuilder expr = new StringBuilder();
                    expr.append("(case when m.member is not null then 'INDIVIDUAL' ");
                    expr.append("      when b.class =  :admin and m.free =  true then 'FREE_TO_GROUP' ");
                    expr.append("      when b.class =  :admin and m.free <> true then 'PAID_TO_GROUP' ");
                    expr.append("      when b.class <> :admin and m.free =  true then 'FREE_FROM_BROKER' ");
                    expr.append("      when b.class <> :admin and m.free <> true then 'PAID_FROM_BROKER' ");
                    expr.append("      else 'UNKNOWN' end)");
                    ArrayList<String> mailingTypesStr = new ArrayList<String>(mailingTypes.size());
                    for (SmsMailingType mailingType : mailingTypes) {
                        mailingTypesStr.add(mailingType.name());
                    }
                    HibernateHelper.addInParameterToQuery(hql, namedParameters, expr.toString(), mailingTypesStr);
                    break;
                }
                case NOTIFICATION: {
                    Collection<Message.Type> messageTypes = null;
                    if (query instanceof SmsLogReportQuery) {
                        messageTypes = ((SmsLogReportQuery)query).getMessageTypes();
                    }
                    if (CollectionUtils.isEmpty(messageTypes)) {
                        hql.append(" and l.messageType is not null");
                        break;
                    }
                    HibernateHelper.addInParameterToQuery(hql, namedParameters, "l.messageType", messageTypes);
                    break;
                }
                case SMS_OPERATION: {
                    Collection<SmsType> smsTypes = null;
                    if (query instanceof SmsLogReportQuery) {
                        smsTypes = ((SmsLogReportQuery)query).getSmsTypes();
                    }
                    if (CollectionUtils.isEmpty(smsTypes)) {
                        hql.append(" and l.smsType is not null");
                        break;
                    }
                    HibernateHelper.addInParameterToQuery(hql, namedParameters, "l.smsType", smsTypes);
                }
            }
        }
    }
}

