/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.sms;

import java.lang.constant.Constable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.JDBCCallback;
import nl.strohalm.cyclos.dao.sms.SmsMailingDAO;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.sms.SmsMailing;
import nl.strohalm.cyclos.entities.sms.SmsMailingQuery;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import org.apache.commons.collections.CollectionUtils;

public class SmsMailingDAOImpl
extends BaseDAOImpl<SmsMailing>
implements SmsMailingDAO {
    public SmsMailingDAOImpl() {
        super(SmsMailing.class);
    }

    @Override
    public void assignUsersToSend(final SmsMailing smsMailing, final MemberCustomField smsCustomField) {
        this.runNative(new JDBCCallback(){

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                Collection<MemberGroup> groups = smsMailing.getGroups();
                Member broker = (Member)(LoggedUser.isBroker() ? LoggedUser.element() : null);
                ArrayList<Constable> params = new ArrayList<Constable>();
                params.add(smsMailing.getId());
                params.add(smsCustomField.getId());
                StringBuilder sql = new StringBuilder();
                sql.append(" insert into sms_mailings_pending_to_send (sms_mailing_id, member_id)");
                sql.append(" select ?, m.id ");
                sql.append(" from custom_field_values fv inner join members m on fv.member_id = m.id left join member_sms_status s on m.id = s.member_id inner join groups g on m.group_id = g.id");
                sql.append(" where fv.field_id = ?");
                sql.append("  and length(fv.string_value) > 0");
                if (!smsMailing.isSingleMember() && CollectionUtils.isNotEmpty(groups)) {
                    sql.append(" and m.group_id in (");
                    Iterator<MemberGroup> iterator = groups.iterator();
                    while (iterator.hasNext()) {
                        MemberGroup group = iterator.next();
                        sql.append('?');
                        if (iterator.hasNext()) {
                            sql.append(',');
                        }
                        params.add(group.getId());
                    }
                    sql.append(" )");
                }
                if (broker != null) {
                    sql.append(" and m.member_broker_id = ?");
                    params.add(broker.getId());
                }
                if (smsMailing.isSingleMember()) {
                    sql.append(" and m.id = ?");
                    params.add(smsMailing.getMember().getId());
                }
                if (!smsMailing.isSingleMember()) {
                    String acceptColumn = smsMailing.isFree() ? "accept_free_mailing" : "accept_paid_mailing";
                    sql.append(" and (s.id is null and g.").append("member_default_").append(acceptColumn).append(" = ?").append(" or s.").append(acceptColumn).append(" = ?)");
                    params.add(Boolean.valueOf(true));
                    params.add(Boolean.valueOf(true));
                }
                jdbc.execute(sql.toString(), params.toArray());
                String updateSentSQL = "update sms_mailings m set m.sent_sms = (select count(*) from sms_mailings_pending_to_send p where p.sms_mailing_id = m.id) where m.id = ?";
                jdbc.execute("update sms_mailings m set m.sent_sms = (select count(*) from sms_mailings_pending_to_send p where p.sms_mailing_id = m.id) where m.id = ?", smsMailing.getId());
            }
        });
    }

    public List<SmsMailing> listUnfinishedMailings() {
        return this.list("from SmsMailing m where exists elements(m.pendingToSend)", null);
    }

    @Override
    public Member nextMemberToSend(SmsMailing smsMailing) {
        return (Member)this.getSession().createFilter(smsMailing.getPendingToSend(), "where 1=1").setMaxResults(1).uniqueResult();
    }

    @Override
    public void removeMemberFromPending(final SmsMailing smsMailing, final Member member) {
        this.runNative(new JDBCCallback(){

            @Override
            public void execute(JDBCWrapper jdbc) throws SQLException {
                jdbc.execute("delete from sms_mailings_pending_to_send where sms_mailing_id = ? and member_id = ?", smsMailing.getId(), member.getId());
            }
        });
    }

    @Override
    public List<SmsMailing> search(SmsMailingQuery query) {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        StringBuilder hql = new StringBuilder("select m from ").append(SmsMailing.class.getName()).append(" m ");
        HibernateHelper.appendJoinFetch(hql, SmsMailing.class, "m", query.getFetch());
        hql.append("left join fetch m.member mbr where 1=1 ");
        if (query.getRecipient() == SmsMailingQuery.Recipient.GROUPS) {
            hql.append(" and mbr is null");
        } else if (query.getRecipient() == SmsMailingQuery.Recipient.MEMBER) {
            hql.append(" and mbr is not null");
        }
        HibernateHelper.addPeriodParameterToQuery(hql, namedParameters, "m.date", query.getPeriod());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "m.by", query.getBroker());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "m.finished", query.getFinished());
        HibernateHelper.addParameterToQuery(hql, namedParameters, "m.member", query.getMember());
        if (CollectionUtils.isNotEmpty(query.getGroups())) {
            hql.append(" and ((mbr is not null");
            HibernateHelper.addInParameterToQuery(hql, namedParameters, "mbr.group", query.getGroups());
            hql.append(")");
            hql.append(" or exists (");
            hql.append("     select g.id");
            hql.append("     from MemberGroup g");
            hql.append("     where (g in elements(m.groups) and g in (:_groups_)) or m.by.group in (:_groups_)");
            namedParameters.put("_groups_", query.getGroups());
            hql.append(" ))");
        }
        HibernateHelper.appendOrder(hql, "m.date desc");
        return this.list(query, hql.toString(), namedParameters);
    }
}

