/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.EntityVO;
import org.springframework.beans.BeanWrapperImpl;

public abstract class Entity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7165508156631393668L;
    private Long id;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Entity)) {
            return false;
        }
        Long id = this.getId();
        Class<? extends Entity> thisRealClass = EntityHelper.getRealClass(this);
        Class<? extends Entity> otherRealClass = EntityHelper.getRealClass((Entity)obj);
        if (id != null && (thisRealClass.isAssignableFrom(otherRealClass) || otherRealClass.isAssignableFrom(thisRealClass))) {
            Entity other = (Entity)obj;
            return id.equals(other.getId());
        }
        return false;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        try {
            return new BeanWrapperImpl((Object)this).getPropertyValue("name").toString();
        }
        catch (Exception e) {
            return this.id + "#" + this.getClass().getSimpleName();
        }
    }

    public Map<String, Object> getVariableValues(LocalSettings localSettings) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        this.appendVariableValues(values, localSettings);
        return values;
    }

    public int hashCode() {
        Long id = this.getId();
        return id == null ? super.hashCode() : id.hashCode();
    }

    public boolean isPersistent() {
        return this.id != null;
    }

    public boolean isTransient() {
        return this.id == null;
    }

    public EntityVO readOnlyView() {
        return new EntityVO(this.getId(), this.getName());
    }

    public void setId(Long id) throws IllegalStateException {
        this.id = id;
    }

    public abstract String toString();

    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
    }

    protected Object writeReplace() {
        if (this instanceof EntityReference) {
            return new EntityReference.Resolver(this.getClass().getSuperclass(), this.getId());
        }
        return this;
    }
}

