/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities;

import java.util.Calendar;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Indexable;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class IndexOperation
extends Entity {
    private static final long serialVersionUID = -7460146693838037965L;
    private Calendar date;
    private EntityType entityType;
    private OperationType operationType;
    private Long entityId;

    public Calendar getDate() {
        return this.date;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    @Override
    public String toString() {
        return FormatObject.formatObject(this.date) + " " + this.entityType + " " + this.operationType + (this.entityId == null ? "" : " " + this.entityId);
    }

    public static enum OperationType implements StringValuedEnum
    {
        REBUILD("REB"),
        REBUILD_IF_CORRUPT("RIC"),
        ADD("ADD"),
        REMOVE("REM");

        private final String value;

        private OperationType(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum EntityType implements StringValuedEnum
    {
        ADVERTISEMENT(Ad.class, "ADV"),
        MEMBER(Member.class, "MBR"),
        MEMBER_RECORD(MemberRecord.class, "MRC"),
        ADMIN(Administrator.class, "ADM"),
        OPERATOR(Operator.class, "OPR");

        private final Class<? extends Indexable> entityClass;
        private final String value;

        public static EntityType from(Class<? extends Indexable> entityClass) {
            for (EntityType entityType : EntityType.values()) {
                if (!entityType.getEntityClass().equals(entityClass)) continue;
                return entityType;
            }
            throw new IllegalArgumentException("No EntityType for " + entityClass);
        }

        private EntityType(Class<? extends Indexable> entityClass, String value) {
            this.entityClass = entityClass;
            this.value = value;
        }

        public Class<? extends Indexable> getEntityClass() {
            return this.entityClass;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

