/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.ChannelPrincipal;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class Channel
extends Entity
implements Comparable<Channel> {
    public static final PrincipalType DEFAULT_PRINCIPAL_TYPE = new PrincipalType(Principal.USER);
    public static final String WEB = "web";
    public static final String WAP1 = "wap1";
    public static final String WAP2 = "wap2";
    public static final String WEBSHOP = "webshop";
    public static final String POSWEB = "posweb";
    public static final String POS = "pos";
    public static final String REST = "rest";
    private static final List<String> BUILTIN_CHANNELS;
    private static final long serialVersionUID = 1902644598506785461L;
    private String internalName;
    private String displayName;
    private Credentials credentials;
    private String paymentRequestWebServiceUrl;
    private Collection<ChannelPrincipal> principals;
    private Collection<MemberGroup> groups;

    public static List<String> listBuiltin() {
        return BUILTIN_CHANNELS;
    }

    public boolean allows(PrincipalType principalType) {
        for (PrincipalType type : this.getPrincipalTypes()) {
            if (!type.equals(principalType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Channel o) {
        try {
            return this.displayName.compareTo(o.displayName);
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public PrincipalType getDefaultPrincipalType() {
        if (CollectionUtils.isNotEmpty(this.principals)) {
            ChannelPrincipal defaultPrincipal = null;
            for (ChannelPrincipal principal : this.principals) {
                if (!principal.isDefault()) continue;
                defaultPrincipal = principal;
                break;
            }
            if (defaultPrincipal == null) {
                defaultPrincipal = this.principals.iterator().next();
            }
            return defaultPrincipal.asPrincipalType();
        }
        return DEFAULT_PRINCIPAL_TYPE;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Collection<MemberGroup> getGroups() {
        return this.groups;
    }

    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    public String getPaymentRequestWebServiceUrl() {
        return this.paymentRequestWebServiceUrl;
    }

    public Set<MemberCustomField> getPrincipalCustomFields() {
        HashSet<MemberCustomField> fields = new HashSet<MemberCustomField>();
        for (ChannelPrincipal principal : this.principals) {
            MemberCustomField field = principal.getCustomField();
            if (field == null) continue;
            fields.add(field);
        }
        return fields;
    }

    public Collection<ChannelPrincipal> getPrincipals() {
        return this.principals;
    }

    public Set<PrincipalType> getPrincipalTypes() {
        if (CollectionUtils.isEmpty(this.principals)) {
            return Collections.singleton(DEFAULT_PRINCIPAL_TYPE);
        }
        LinkedHashSet<PrincipalType> principalTypes = new LinkedHashSet<PrincipalType>();
        for (ChannelPrincipal cp : this.principals) {
            principalTypes.add(cp.asPrincipalType());
        }
        return principalTypes;
    }

    public boolean isPaymentRequestSupported() {
        return StringUtils.isNotEmpty((String)this.paymentRequestWebServiceUrl);
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setGroups(Collection<MemberGroup> groups) {
        this.groups = groups;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public void setPaymentRequestWebServiceUrl(String paymentRequestWebServiceUrl) {
        this.paymentRequestWebServiceUrl = paymentRequestWebServiceUrl;
    }

    public void setPrincipals(Collection<ChannelPrincipal> principals) {
        this.principals = principals;
    }

    public void setPrincipalTypes(Set<PrincipalType> principalTypes, PrincipalType defaultPrincipalType) {
        this.principals = new ArrayList<ChannelPrincipal>();
        for (PrincipalType principalType : principalTypes) {
            ChannelPrincipal channelPrincipal = new ChannelPrincipal();
            channelPrincipal.setChannel(this);
            channelPrincipal.setPrincipal(principalType.getPrincipal());
            channelPrincipal.setCustomField(principalType.getCustomField());
            channelPrincipal.setDefault(principalType.equals(defaultPrincipalType));
            this.principals.add(channelPrincipal);
        }
    }

    @Override
    public String toString() {
        return this.internalName;
    }

    static {
        ArrayList<String> channels = new ArrayList<String>();
        channels.add(WEB);
        channels.add(WAP1);
        channels.add(WAP2);
        channels.add(WEBSHOP);
        channels.add(POSWEB);
        channels.add(POS);
        channels.add(REST);
        BUILTIN_CHANNELS = Collections.unmodifiableList(channels);
    }

    public static enum Relationships implements Relationship
    {
        PRINCIPALS("principals"),
        GROUPS("groups");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Principal implements StringValuedEnum
    {
        USER("U", "login.username"),
        EMAIL("E", "member.email"),
        CARD("C", "card.card"),
        CUSTOM_FIELD("F", null);

        private final String value;
        private final String key;

        private Principal(String value, String key) {
            this.value = value;
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isNumeric() {
            return this == CARD;
        }
    }

    public static enum Credentials implements StringValuedEnum
    {
        DEFAULT("D"),
        LOGIN_PASSWORD("L"),
        TRANSACTION_PASSWORD("T"),
        PIN("P"),
        CARD_SECURITY_CODE("C");

        private final String value;

        private Credentials(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

