/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.access;

import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.LoginHistoryLog;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public abstract class User
extends Entity {
    private static final long serialVersionUID = 545429548353183777L;
    private Element element;
    private String salt;
    private String username;
    private Calendar lastLogin;
    private String password;
    private Calendar passwordDate;
    private Calendar passwordBlockedUntil;
    private String transactionPassword;
    private TransactionPasswordStatus transactionPasswordStatus = TransactionPasswordStatus.NEVER_CREATED;
    private Collection<LoginHistoryLog> loginHistory;

    public Element getElement() {
        return this.element;
    }

    public Calendar getLastLogin() {
        return this.lastLogin;
    }

    public Collection<LoginHistoryLog> getLoginHistory() {
        return this.loginHistory;
    }

    public String getPassword() {
        return this.password;
    }

    public Calendar getPasswordBlockedUntil() {
        return this.passwordBlockedUntil;
    }

    public Calendar getPasswordDate() {
        return this.passwordDate;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getTransactionPassword() {
        return this.transactionPassword;
    }

    public TransactionPasswordStatus getTransactionPasswordStatus() {
        return this.transactionPasswordStatus;
    }

    public String getUsername() {
        return this.username;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setLastLogin(Calendar lastLogin) {
        this.lastLogin = lastLogin;
    }

    public void setLoginHistory(Collection<LoginHistoryLog> loginHistory) {
        this.loginHistory = loginHistory;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordBlockedUntil(Calendar passwordBlockedUntil) {
        this.passwordBlockedUntil = passwordBlockedUntil;
    }

    public void setPasswordDate(Calendar passwordGeneratedAt) {
        this.passwordDate = passwordGeneratedAt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setTransactionPassword(String transactionPassword) {
        this.transactionPassword = transactionPassword;
    }

    public void setTransactionPasswordStatus(TransactionPasswordStatus transactionPasswordStatus) {
        this.transactionPasswordStatus = transactionPasswordStatus;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String toString() {
        return this.element == null ? this.getId() + " - " + this.getUsername() : this.element.toString();
    }

    public static enum TransactionPasswordStatus implements StringValuedEnum
    {
        ACTIVE("A"),
        PENDING("P"),
        BLOCKED("B"),
        NEVER_CREATED("N");

        private final String value;

        private TransactionPasswordStatus(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isGenerationAllowed() {
            return this == PENDING || this == NEVER_CREATED;
        }
    }

    public static enum Relationships implements Relationship
    {
        ELEMENT("element"),
        LOGIN_HISTORY("loginHistory");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

