/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.Rated;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.rates.RatesResultDTO;
import nl.strohalm.cyclos.utils.DataObject;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;

public class AccountStatus
extends DataObject
implements Rated {
    private static final long serialVersionUID = -7864009622327627438L;
    private Account account;
    private BigDecimal balance = BigDecimal.ZERO;
    private BigDecimal reservedAmount = BigDecimal.ZERO;
    private BigDecimal creditLimit = BigDecimal.ZERO;
    private BigDecimal upperCreditLimit = BigDecimal.ZERO;
    private RatesResultDTO rates;
    private Calendar date;

    public Account getAccount() {
        return this.account;
    }

    public BigDecimal getaRate() {
        if (this.rates != null) {
            return this.rates.getaRate();
        }
        return null;
    }

    public BigDecimal getAvailableBalance() {
        return this.creditLimit == null ? null : this.balance.subtract(this.reservedAmount).add(this.creditLimit.abs());
    }

    public BigDecimal getAvailableBalanceWithoutCreditLimit() {
        return this.balance.subtract(this.reservedAmount);
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public BigDecimal getCreditLimit() {
        return this.creditLimit;
    }

    public Calendar getDate() {
        return this.date;
    }

    public BigDecimal getdRate() {
        if (this.rates != null) {
            return this.rates.getdRate();
        }
        return null;
    }

    @Override
    public Calendar getEmissionDate() {
        if (this.rates != null) {
            return this.rates.getEmissionDate();
        }
        return null;
    }

    @Override
    public Calendar getExpirationDate() {
        if (this.rates != null) {
            return this.rates.getExpirationDate();
        }
        return null;
    }

    @Override
    public BigDecimal getiRate() {
        if (this.rates != null) {
            return this.rates.getiRate();
        }
        return null;
    }

    public RatesResultDTO getRates() {
        return this.rates;
    }

    public BigDecimal getReservedAmount() {
        return this.reservedAmount;
    }

    public BigDecimal getUpperCreditLimit() {
        return this.upperCreditLimit;
    }

    public Map<String, Object> getVariableValues(LocalSettings localSettings) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        UnitsConverter unitsConverter = localSettings.getUnitsConverter(this.getAccount().getType().getCurrency().getPattern());
        values.put("balance", unitsConverter.toString(this.getBalance()));
        values.put("available_balance", unitsConverter.toString(this.getAvailableBalance()));
        values.put("reserved_amount", unitsConverter.toString(this.getReservedAmount()));
        values.put("credit_limit", unitsConverter.toString(this.getCreditLimit().abs().negate()));
        values.put("upper_credit_limit", unitsConverter.toString(this.getUpperCreditLimit()));
        return values;
    }

    public BigDecimal getVirtualRatedBalance() {
        if (this.rates != null) {
            return this.rates.getVirtualRatedBalance();
        }
        return null;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public void setCreditLimit(BigDecimal creditLimit) {
        this.creditLimit = creditLimit;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setRates(RatesResultDTO rates) {
        this.rates = rates;
    }

    public void setReservedAmount(BigDecimal reservedAmount) {
        this.reservedAmount = reservedAmount;
    }

    public void setUpperCreditLimit(BigDecimal upperCreditLimit) {
        this.upperCreditLimit = upperCreditLimit;
    }
}

