/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts;

import java.util.Collection;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public abstract class AccountType
extends Entity
implements Comparable<AccountType> {
    private static final long serialVersionUID = -3362966482758151026L;
    private String description;
    private String name;
    private Currency currency;
    private Collection<TransferType> fromTransferTypes;
    private Collection<TransferType> toTransferTypes;
    private Collection<PaymentFilter> paymentFilters;

    @Override
    public int compareTo(AccountType o) {
        int compareByName = this.name.compareTo(o.name);
        int compareById = this.getId().compareTo(o.getId());
        return compareByName == 0 ? compareById : compareByName;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<TransferType> getFromTransferTypes() {
        return this.fromTransferTypes;
    }

    public abstract LimitType getLimitType();

    @Override
    public String getName() {
        return this.name;
    }

    public abstract Nature getNature();

    public Collection<PaymentFilter> getPaymentFilters() {
        return this.paymentFilters;
    }

    public Collection<TransferType> getToTransferTypes() {
        return this.toTransferTypes;
    }

    public boolean isLimited() {
        return true;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFromTransferTypes(Collection<TransferType> fromTransferTypes) {
        this.fromTransferTypes = fromTransferTypes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPaymentFilters(Collection<PaymentFilter> paymentFilters) {
        this.paymentFilters = paymentFilters;
    }

    public void setToTransferTypes(Collection<TransferType> toTransferTypes) {
        this.toTransferTypes = toTransferTypes;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum Relationships implements Relationship
    {
        CURRENCY("currency"),
        FROM_TRANSFER_TYPES("fromTransferTypes"),
        TO_TRANSFER_TYPES("toTransferTypes"),
        PAYMENT_FILTERS("paymentFilters");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Nature implements StringValuedEnum
    {
        MEMBER("M"),
        SYSTEM("S");

        private final String value;

        private Nature(String value) {
            this.value = value;
        }

        public Class<? extends AccountType> getType() {
            return this == SYSTEM ? SystemAccountType.class : MemberAccountType.class;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum LimitType {
        LIMITED,
        UNLIMITED;

    }
}

