/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts;

import java.math.BigDecimal;
import nl.strohalm.cyclos.entities.accounts.InitializableRateParameters;
import nl.strohalm.cyclos.utils.BigDecimalHelper;
import nl.strohalm.cyclos.utils.FormatObject;

public class DRateParameters
extends InitializableRateParameters {
    private static final long serialVersionUID = -1758988593868498202L;
    private BigDecimal interest;
    private BigDecimal baseMalus;
    private BigDecimal minimalD;

    public BigDecimal getBaseMalus() {
        return this.baseMalus;
    }

    public BigDecimal getBaseMalusTerm() {
        return BigDecimal.ONE.subtract(BigDecimalHelper.asPercentFraction(this.baseMalus));
    }

    public BigDecimal getInterest() {
        return this.interest;
    }

    public BigDecimal getMinimalD() {
        return this.minimalD;
    }

    public void setBaseMalus(BigDecimal baseMalus) {
        this.baseMalus = baseMalus;
    }

    public void setInterest(BigDecimal interest) {
        this.interest = interest;
    }

    public void setMinimalD(BigDecimal minimalD) {
        this.minimalD = minimalD;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getId());
        result.append(" - interest = ");
        result.append(FormatObject.formatObject(this.getInterest()));
        result.append(", base malus = ");
        result.append(FormatObject.formatObject(this.getBaseMalus()));
        result.append(", minimal D = ");
        result.append(FormatObject.formatObject(this.getMinimalD()));
        result.append(", init value = ");
        result.append(FormatObject.formatObject(this.getInitValue()));
        return result.toString();
    }
}

