/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts;

import java.math.BigDecimal;
import java.util.Calendar;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class MemberAccount
extends Account {
    private static final long serialVersionUID = 2295911628180790052L;
    private Member member;
    private Status status = Status.ACTIVE;
    private Action action;
    private Calendar lastLowUnitsSent;

    public MemberAccount() {
    }

    public MemberAccount(Member owner) {
        this.setMember(owner);
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public BigDecimal getCreditLimit() {
        BigDecimal fromSuper = super.getCreditLimit();
        if (fromSuper == null) {
            return BigDecimal.ZERO;
        }
        return fromSuper;
    }

    public Calendar getLastLowUnitsSent() {
        return this.lastLowUnitsSent;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public AccountType.Nature getNature() {
        return AccountType.Nature.MEMBER;
    }

    @Override
    public Member getOwner() {
        return this.getMember();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setLastLowUnitsSent(Calendar lastLowUnitsSent) {
        this.lastLowUnitsSent = lastLowUnitsSent;
    }

    public void setMember(Member owner) {
        this.member = owner;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return this.getId() + ", type: " + FormatObject.formatObject(this.getType()) + ", member: " + FormatObject.formatObject(this.getMember());
    }

    public static enum Status implements StringValuedEnum
    {
        ACTIVE("A"),
        INACTIVE("I");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        MEMBER("member");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Action implements StringValuedEnum
    {
        ACTIVATE("A"),
        REMOVE("R");

        private final String value;

        private Action(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

