/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts;

import java.math.BigDecimal;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.groups.AdminGroup;

public class SystemAccountType
extends AccountType {
    private static final long serialVersionUID = -3356210066125175997L;
    private SystemAccount account;
    private BigDecimal creditLimit;
    private BigDecimal upperCreditLimit;
    private Collection<AdminGroup> viewedByGroups;
    private Collection<ExternalAccount> externalAccounts;

    public SystemAccount getAccount() {
        return this.account;
    }

    public BigDecimal getCreditLimit() {
        return this.creditLimit;
    }

    public Collection<ExternalAccount> getExternalAccounts() {
        return this.externalAccounts;
    }

    @Override
    public AccountType.LimitType getLimitType() {
        return this.account.getCreditLimit() == null ? AccountType.LimitType.UNLIMITED : AccountType.LimitType.LIMITED;
    }

    @Override
    public AccountType.Nature getNature() {
        return AccountType.Nature.SYSTEM;
    }

    public BigDecimal getUpperCreditLimit() {
        return this.upperCreditLimit;
    }

    public Collection<AdminGroup> getViewedByGroups() {
        return this.viewedByGroups;
    }

    @Override
    public boolean isLimited() {
        return this.account.getCreditLimit() != null;
    }

    public void setAccount(SystemAccount account) {
        this.account = account;
        if (account != null) {
            this.setCreditLimit(account.getCreditLimit());
            this.setUpperCreditLimit(account.getUpperCreditLimit());
        }
    }

    public void setCreditLimit(BigDecimal creditLimit) {
        this.creditLimit = creditLimit;
    }

    public void setExternalAccounts(Collection<ExternalAccount> externalAccounts) {
        this.externalAccounts = externalAccounts;
    }

    public void setUpperCreditLimit(BigDecimal upperCreditLimit) {
        this.upperCreditLimit = upperCreditLimit;
    }

    public void setViewedByGroups(Collection<AdminGroup> viewedByGroups) {
        this.viewedByGroups = viewedByGroups;
    }

    public static enum Relationships implements Relationship
    {
        ACCOUNT("account"),
        VIEWED_BY_GROUPS("viewedByGroups"),
        EXTERNAL_ACCOUNTS("externalAccounts");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

