/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.cards;

import java.math.BigInteger;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.conversion.CardNumberConverter;
import nl.strohalm.cyclos.utils.conversion.Converter;

public class CardType
extends Entity {
    private static final long serialVersionUID = 4768078304847226115L;
    private String name;
    private String cardFormatNumber = "#### #### #### ####";
    private TimePeriod defaultExpiration = new TimePeriod(1, TimePeriod.Field.YEARS);
    private CardSecurityCode cardSecurityCode = CardSecurityCode.NOT_USED;
    private boolean showCardSecurityCode = false;
    private boolean ignoreDayInExpirationDate = true;
    private RangeConstraint cardSecurityCodeLength = new RangeConstraint(4, 4);
    private int maxSecurityCodeTries = 3;
    private TimePeriod securityCodeBlockTime = new TimePeriod(1, TimePeriod.Field.DAYS);
    private transient Converter<BigInteger> converter;

    public String getCardFormatNumber() {
        return this.cardFormatNumber;
    }

    public Converter<BigInteger> getCardNumberConverter() {
        if (this.converter == null) {
            this.converter = new CardNumberConverter(this.cardFormatNumber);
        }
        return this.converter;
    }

    public CardSecurityCode getCardSecurityCode() {
        return this.cardSecurityCode;
    }

    public RangeConstraint getCardSecurityCodeLength() {
        return this.cardSecurityCodeLength;
    }

    public TimePeriod getDefaultExpiration() {
        return this.defaultExpiration;
    }

    public int getMaxSecurityCodeTries() {
        return this.maxSecurityCodeTries;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TimePeriod getSecurityCodeBlockTime() {
        return this.securityCodeBlockTime;
    }

    public boolean isIgnoreDayInExpirationDate() {
        return this.ignoreDayInExpirationDate;
    }

    public boolean isShowCardSecurityCode() {
        return this.showCardSecurityCode;
    }

    public void setCardFormatNumber(String cardFormatNumber) {
        this.cardFormatNumber = cardFormatNumber;
        this.converter = null;
    }

    public void setCardSecurityCode(CardSecurityCode cardSecurityCode) {
        this.cardSecurityCode = cardSecurityCode;
    }

    public void setCardSecurityCodeLength(RangeConstraint cardSecurityCodeLength) {
        this.cardSecurityCodeLength = cardSecurityCodeLength;
    }

    public void setDefaultExpiration(TimePeriod defaultExpiration) {
        this.defaultExpiration = defaultExpiration;
    }

    public void setIgnoreDayInExpirationDate(boolean ignoreDayInExpirationDate) {
        this.ignoreDayInExpirationDate = ignoreDayInExpirationDate;
    }

    public void setMaxSecurityCodeTries(int maxSecurityCodeTries) {
        this.maxSecurityCodeTries = maxSecurityCodeTries;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSecurityCodeBlockTime(TimePeriod securityCodeBlockTime) {
        this.securityCodeBlockTime = securityCodeBlockTime;
    }

    public void setShowCardSecurityCode(boolean showCardSecurityCode) {
        this.showCardSecurityCode = showCardSecurityCode;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum CardSecurityCode implements StringValuedEnum
    {
        NOT_USED("N"),
        MANUAL("M"),
        AUTOMATIC("A");

        private final String value;

        private CardSecurityCode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

