/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.external;

import java.math.BigDecimal;
import java.util.Calendar;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImport;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class ExternalTransfer
extends Entity {
    private static final long serialVersionUID = 8537065201842074164L;
    private ExternalAccount account;
    private ExternalTransferImport transferImport;
    private ExternalTransferType type;
    private Status status = Status.PENDING;
    private Calendar date;
    private BigDecimal amount;
    private String description;
    private Member member;
    private Integer lineNumber;
    private String comments;

    public ExternalAccount getAccount() {
        return this.account;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getComments() {
        return this.comments;
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Member getMember() {
        return this.member;
    }

    public Status getStatus() {
        return this.status;
    }

    public SummaryStatus getSummaryStatus() {
        if (this.status != null) {
            switch (this.status) {
                case PENDING: {
                    return this.isComplete() ? SummaryStatus.COMPLETE_PENDING : SummaryStatus.INCOMPLETE_PENDING;
                }
                case CHECKED: {
                    return SummaryStatus.CHECKED;
                }
                case PROCESSED: {
                    return SummaryStatus.PROCESSED;
                }
            }
        }
        return null;
    }

    public ExternalTransferImport getTransferImport() {
        return this.transferImport;
    }

    public ExternalTransferType getType() {
        return this.type;
    }

    public boolean isComplete() {
        return this.type != null && (this.type != null && this.type.getAction() == ExternalTransferType.Action.IGNORE || this.member != null) && this.date != null && this.amount != null;
    }

    public void setAccount(ExternalAccount account) {
        this.account = account;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTransferImport(ExternalTransferImport transferImport) {
        this.transferImport = transferImport;
    }

    public void setType(ExternalTransferType type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return this.getId() + " - date: " + FormatObject.formatObject(this.getDate()) + ", amount: " + FormatObject.formatObject(this.getAmount()) + ", member: " + this.member;
    }

    public static enum SummaryStatus {
        INCOMPLETE_PENDING,
        COMPLETE_PENDING,
        CHECKED,
        PROCESSED,
        TOTAL;

    }

    public static enum Status implements StringValuedEnum
    {
        PENDING("N"),
        CHECKED("C"),
        PROCESSED("P");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        ACCOUNT("account"),
        TYPE("type"),
        TRANSFER_IMPORT("transferImport"),
        MEMBER("member");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

