/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.external.filemapping;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.CSVFileMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FieldMapping;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.conversion.StringTrimmerConverter;
import nl.strohalm.cyclos.utils.csv.CSVReader;
import nl.strohalm.cyclos.utils.transactionimport.IllegalTransactionFileFormatException;
import nl.strohalm.cyclos.utils.transactionimport.TransactionFileImport;
import nl.strohalm.cyclos.utils.transactionimport.TransactionImportDTO;
import org.apache.commons.lang.StringUtils;

public class CSVImport
implements TransactionFileImport {
    private static final Converter<String> DEFAULT_CONVERTER = new StringTrimmerConverter(" \t\n\r");
    private final CSVFileMapping mapping;
    private MessageResolver messageResolver;

    public CSVImport(CSVFileMapping mapping, MessageResolver messageResolver) {
        this.mapping = mapping;
        this.messageResolver = messageResolver;
    }

    @Override
    public List<TransactionImportDTO> readTransactions(Reader in) throws IllegalTransactionFileFormatException, IOException {
        List<String> line;
        int lineNumber = 0;
        for (int i = 0; i < this.mapping.getHeaderLines(); ++i) {
            ++lineNumber;
            this.readLine(in);
        }
        LinkedList<TransactionImportDTO> transactions = new LinkedList<TransactionImportDTO>();
        while ((line = this.readLine(in)) != null) {
            ++lineNumber;
            if (line.isEmpty()) continue;
            TransactionImportDTO transaction = new TransactionImportDTO();
            int column = -1;
            StringBuilder comments = new StringBuilder();
            for (FieldMapping field : this.mapping.getFields()) {
                ++column;
                Converter<?> converter = this.resolveConverter(field);
                if (converter == null) continue;
                String stringValue = StringUtils.trimToNull((String)line.get(column));
                try {
                    Object value = converter.valueOf(stringValue);
                    String property = field.getField().getDtoProperty();
                    if (field.getField().equals(FieldMapping.Field.MEMBER_CUSTOM_FIELD)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(field.getMemberField().getInternalName(), (String)value);
                        value = map;
                    }
                    PropertyHelper.set(transaction, property, value);
                }
                catch (Exception e) {
                    if (comments.length() > 0) {
                        comments.append("\n");
                    }
                    comments.append(this.messageResolver.message("externalTransferImport.error.importing.comments", field.getName(), column + 1, stringValue));
                }
            }
            transaction.setLineNumber(lineNumber);
            transaction.setComments(StringUtils.trimToNull((String)comments.toString()));
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<String> readLine(Reader in) throws IOException {
        return CSVReader.readLine(in, this.mapping.getStringQuote().charValue(), this.mapping.getColumnSeparator().charValue());
    }

    private Converter<?> resolveConverter(FieldMapping field) {
        Converter<Object> converter;
        switch (field.getField()) {
            case AMOUNT: {
                converter = this.mapping.getNumberConverter();
                break;
            }
            case NEGATE_AMOUNT: {
                converter = this.mapping.getNegateAmountConverter();
                break;
            }
            case DATE: {
                converter = this.mapping.getDateConverter();
                break;
            }
            case IGNORED: {
                converter = null;
                break;
            }
            default: {
                converter = DEFAULT_CONVERTER;
            }
        }
        return converter;
    }
}

