/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.external.filemapping;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FieldMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMapping;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.conversion.BooleanConverter;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.conversion.FixedLengthNumberConverter;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import org.apache.commons.lang.StringUtils;

public abstract class FileMappingWithFields
extends FileMapping {
    public static final NumberFormat DEFAULT_NUMBER_FORMAT = NumberFormat.FIXED_POSITION;
    public static final Character DEFAULT_NEGATIVE_AMOUNT_VALUE = new Character('-');
    public static final Integer DEFAULT_DECIMAL_PLACES = new Integer(2);
    public static final Character DEFAULT_DECIMAL_SEPARATOR = new Character('.');
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final long serialVersionUID = -6761459914402653154L;
    private NumberFormat numberFormat;
    private String negativeAmountValue;
    private Integer decimalPlaces;
    private Character decimalSeparator;
    private String dateFormat;
    private Collection<FieldMapping> fields;

    public Converter<Calendar> getDateConverter() {
        String format = this.dateFormat.toLowerCase().replace('m', 'M');
        return new CalendarConverter(format);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public Integer getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public Character getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public Collection<FieldMapping> getFields() {
        return this.fields;
    }

    public Converter<Boolean> getNegateAmountConverter() {
        return new BooleanConverter(String.valueOf(this.negativeAmountValue));
    }

    public String getNegativeAmountValue() {
        return this.negativeAmountValue;
    }

    public Converter<BigDecimal> getNumberConverter() {
        if (this.numberFormat == NumberFormat.FIXED_POSITION) {
            return new FixedLengthNumberConverter<BigDecimal>(BigDecimal.class, this.decimalPlaces);
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.decimalSeparator.charValue());
        symbols.setGroupingSeparator('!');
        DecimalFormat format = new DecimalFormat("0." + StringUtils.repeat((String)"0", (int)this.decimalPlaces), symbols);
        format.setGroupingUsed(false);
        return new NumberConverter<BigDecimal>(BigDecimal.class, format);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDecimalPlaces(Integer decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    public void setDecimalSeparator(Character decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public void setFields(Collection<FieldMapping> fields) {
        this.fields = fields;
    }

    public void setNegativeAmountValue(String negativeAmountValue) {
        this.negativeAmountValue = negativeAmountValue;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public static enum Relationships implements Relationship
    {
        FIELDS("fields");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum NumberFormat implements StringValuedEnum
    {
        FIXED_POSITION("F"),
        WITH_SEPARATOR("S");

        private final String value;

        private NumberFormat(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

