/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.fees.account;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.WeekDay;

public class AccountFee
extends Entity {
    private static final long serialVersionUID = -3296543930198792794L;
    private MemberAccountType accountType;
    private String name;
    private String description;
    private ChargeMode chargeMode;
    private boolean enabled;
    private Calendar enabledSince;
    private RunMode runMode;
    private TimePeriod recurrence;
    private Byte day;
    private Byte hour;
    private InvoiceMode invoiceMode;
    private PaymentDirection paymentDirection;
    private BigDecimal amount;
    private BigDecimal freeBase;
    private TransferType transferType;
    private Collection<MemberGroup> groups;
    private Collection<AccountFeeLog> logs;

    public MemberAccountType getAccountType() {
        return this.accountType;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Amount getAmountValue() {
        Amount amount = new Amount();
        amount.setType(this.chargeMode.getAmountType());
        amount.setValue(this.amount);
        return amount;
    }

    public ChargeMode getChargeMode() {
        return this.chargeMode;
    }

    public Byte getDay() {
        return this.day;
    }

    public String getDescription() {
        return this.description;
    }

    public Calendar getEnabledSince() {
        return this.enabledSince;
    }

    public BigDecimal getFreeBase() {
        return this.freeBase;
    }

    public Collection<MemberGroup> getGroups() {
        return this.groups;
    }

    public Byte getHour() {
        return this.hour;
    }

    public InvoiceMode getInvoiceMode() {
        return this.invoiceMode;
    }

    public AccountFeeLog getLastExecution() {
        return this.logs == null || this.logs.isEmpty() ? null : this.logs.iterator().next();
    }

    public Collection<AccountFeeLog> getLogs() {
        return this.logs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Calendar getNextExecutionDate() {
        Period period;
        if (this.runMode != RunMode.SCHEDULED || this.enabledSince == null) {
            return null;
        }
        AccountFeeLog lastLog = this.getLastExecution();
        if (lastLog == null) {
            period = this.recurrence.currentPeriod(this.enabledSince);
        } else {
            Calendar begin = DateHelper.truncateNextDay(lastLog.getPeriod().getEnd());
            period = this.recurrence.periodStartingAt(begin);
            if (this.enabledSince.after(period.getEnd())) {
                period = this.recurrence.currentPeriod(this.enabledSince);
            }
        }
        Calendar executionDate = DateHelper.truncateNextDay(period.getEnd());
        if (this.enabledSince.after(executionDate)) {
            executionDate = DateHelper.truncateNextDay(this.recurrence.currentPeriod(this.enabledSince).getEnd());
        }
        switch (this.recurrence.getField()) {
            case WEEKS: {
                while (executionDate.get(7) != this.day.byteValue()) {
                    executionDate.add(5, 1);
                }
                break;
            }
            case MONTHS: {
                executionDate.set(5, this.day.byteValue());
            }
        }
        if (this.hour != null) {
            executionDate.set(11, this.hour.byteValue());
        }
        return executionDate;
    }

    public PaymentDirection getPaymentDirection() {
        return this.paymentDirection;
    }

    public TimePeriod getRecurrence() {
        return this.recurrence;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public WeekDay getWeekDay() {
        if (this.recurrence != null && this.recurrence.getField() == TimePeriod.Field.WEEKS) {
            return WeekDay.valueOf(this.day.byteValue());
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isManual() {
        return this.runMode == RunMode.MANUAL;
    }

    public boolean isMemberToSystem() {
        return this.paymentDirection == PaymentDirection.TO_SYSTEM;
    }

    public void setAccountType(MemberAccountType accountType) {
        this.accountType = accountType;
    }

    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    public void setChargeMode(ChargeMode chargeMode) {
        this.chargeMode = chargeMode;
    }

    public void setDay(Byte day) {
        this.day = day;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabledSince(Calendar enabledSince) {
        this.enabledSince = enabledSince;
    }

    public void setFreeBase(BigDecimal freeBase) {
        this.freeBase = freeBase;
    }

    public void setGroups(Collection<MemberGroup> groups) {
        this.groups = groups;
    }

    public void setHour(Byte hour) {
        this.hour = hour;
    }

    public void setInvoiceMode(InvoiceMode invoiceMode) {
        this.invoiceMode = invoiceMode;
    }

    public void setLogs(Collection<AccountFeeLog> logs) {
        this.logs = logs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPaymentDirection(PaymentDirection paymentDirection) {
        this.paymentDirection = paymentDirection;
    }

    public void setRecurrence(TimePeriod recurrence) {
        this.recurrence = recurrence;
    }

    public void setRunMode(RunMode type) {
        this.runMode = type;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        variables.put("account_fee", this.name);
    }

    public static enum RunMode implements StringValuedEnum
    {
        MANUAL("M"),
        SCHEDULED("S");

        private final String value;

        private RunMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        ACCOUNT_TYPE("accountType"),
        GROUPS("groups"),
        LOGS("logs"),
        TRANSFER_TYPE("transferType");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum PaymentDirection implements StringValuedEnum
    {
        TO_SYSTEM("S"),
        TO_MEMBER("M");

        private final String value;

        private PaymentDirection(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum InvoiceMode implements StringValuedEnum
    {
        NOT_ENOUGH_CREDITS("C"),
        NEVER("N"),
        ALWAYS("A");

        private final String value;

        private InvoiceMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum ChargeMode implements StringValuedEnum
    {
        FIXED("FA", Amount.Type.FIXED),
        VOLUME_PERCENTAGE("VP", Amount.Type.PERCENTAGE),
        NEGATIVE_VOLUME_PERCENTAGE("NV", Amount.Type.PERCENTAGE),
        BALANCE_PERCENTAGE("BP", Amount.Type.PERCENTAGE),
        NEGATIVE_BALANCE_PERCENTAGE("NB", Amount.Type.PERCENTAGE);

        private final String value;
        private final Amount.Type amountType;

        private ChargeMode(String value, Amount.Type amountType) {
            this.value = value;
            this.amountType = amountType;
        }

        public Amount.Type getAmountType() {
            return this.amountType;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isBalance() {
            return this == BALANCE_PERCENTAGE || this == NEGATIVE_BALANCE_PERCENTAGE;
        }

        public boolean isFixed() {
            return this == FIXED;
        }

        public boolean isNegative() {
            return this == NEGATIVE_BALANCE_PERCENTAGE || this == NEGATIVE_VOLUME_PERCENTAGE;
        }

        public boolean isVolume() {
            return this == VOLUME_PERCENTAGE || this == NEGATIVE_VOLUME_PERCENTAGE;
        }
    }
}

