/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.fees.account;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.Period;

public class AccountFeeLog
extends Entity {
    private static final long serialVersionUID = -1715437658356438694L;
    private AccountFee accountFee;
    private Calendar date;
    private Calendar finishDate;
    private BigDecimal freeBase;
    private Period period;
    private BigDecimal amount;
    private Integer totalMembers;
    private int failedMembers;
    private boolean rechargingFailed;
    private int rechargeAttempt;
    private Collection<Transfer> transfers;
    private Collection<Invoice> invoices;
    private Collection<Member> pendingToCharge;

    public AccountFee getAccountFee() {
        return this.accountFee;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Amount getAmountValue() {
        Amount amount = new Amount();
        amount.setType(this.accountFee.getChargeMode().getAmountType());
        amount.setValue(this.amount);
        return amount;
    }

    public Calendar getDate() {
        return this.date;
    }

    public int getFailedMembers() {
        return this.failedMembers;
    }

    public Calendar getFinishDate() {
        return this.finishDate;
    }

    public BigDecimal getFreeBase() {
        return this.freeBase;
    }

    public Collection<Invoice> getInvoices() {
        return this.invoices;
    }

    public Collection<Member> getPendingToCharge() {
        return this.pendingToCharge;
    }

    public Period getPeriod() {
        return this.period;
    }

    public int getRechargeAttempt() {
        return this.rechargeAttempt;
    }

    public Integer getTotalMembers() {
        return this.totalMembers;
    }

    public Collection<Transfer> getTransfers() {
        return this.transfers;
    }

    public boolean isFinished() {
        return this.finishDate != null;
    }

    public boolean isRechargingFailed() {
        return this.rechargingFailed;
    }

    public boolean isRunning() {
        return this.finishDate == null;
    }

    public void setAccountFee(AccountFee accountFee) {
        this.accountFee = accountFee;
    }

    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setFailedMembers(int failedMembers) {
        this.failedMembers = failedMembers;
    }

    public void setFinishDate(Calendar finishDate) {
        this.finishDate = finishDate;
    }

    public void setFreeBase(BigDecimal freeBase) {
        this.freeBase = freeBase;
    }

    public void setInvoices(Collection<Invoice> invoices) {
        this.invoices = invoices;
    }

    public void setPendingToCharge(Collection<Member> pendingToCharge) {
        this.pendingToCharge = pendingToCharge;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public void setRechargeAttempt(int rechargeAttempt) {
        this.rechargeAttempt = rechargeAttempt;
    }

    public void setRechargingFailed(boolean rechargingFailed) {
        this.rechargingFailed = rechargingFailed;
    }

    public void setTotalMembers(Integer totalMembers) {
        this.totalMembers = totalMembers;
    }

    public void setTransfers(Collection<Transfer> transfers) {
        this.transfers = transfers;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.accountFee + " at " + FormatObject.formatObject(this.date);
    }

    public static enum Relationships implements Relationship
    {
        ACCOUNT_FEE("accountFee"),
        TRANSFERS("transfers"),
        INVOICES("invoices"),
        PENDING_TO_CHARGE("pendingToCharge");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

