/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.fees.account;

import java.math.BigDecimal;
import java.util.Calendar;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.members.Member;

public class MemberAccountFeeLog
extends Entity {
    private static final long serialVersionUID = -3632964253062346212L;
    private Calendar date;
    private boolean success;
    private int rechargeAttempt;
    private Member member;
    private BigDecimal amount;
    private AccountFeeLog accountFeeLog;
    private Transfer transfer;
    private Invoice invoice;

    public AccountFeeLog getAccountFeeLog() {
        return this.accountFeeLog;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Calendar getDate() {
        return this.date;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public Member getMember() {
        return this.member;
    }

    public int getRechargeAttempt() {
        return this.rechargeAttempt;
    }

    public Status getStatus() {
        if (!this.success) {
            return Status.ERROR;
        }
        if (this.transfer != null) {
            return Status.TRANSFER;
        }
        if (this.invoice != null) {
            return this.invoice.getStatus() == Invoice.Status.ACCEPTED ? Status.ACCEPTED_INVOICE : Status.OPEN_INVOICE;
        }
        return Status.SKIPPED;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setAccountFeeLog(AccountFeeLog accountFeeLog) {
        this.accountFeeLog = accountFeeLog;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void setRechargeAttempt(int rechargeAttempt) {
        this.rechargeAttempt = rechargeAttempt;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setTransfer(Transfer transfer) {
        this.transfer = transfer;
    }

    @Override
    public String toString() {
        return this.getId() + ", log: " + this.accountFeeLog + ", member: " + this.member;
    }

    public static enum Status {
        ERROR,
        SKIPPED,
        TRANSFER,
        OPEN_INVOICE,
        ACCEPTED_INVOICE;

    }

    public static enum Relationships implements Relationship
    {
        ACCOUNT_FEE_LOG("accountFeeLog"),
        MEMBER("member"),
        TRANSFER("transfer"),
        INVOICE("invoice");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

