/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.fees.transaction;

import java.math.BigDecimal;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.SimpleTransactionFee;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public abstract class TransactionFee
extends Entity {
    private static final long serialVersionUID = -3840663900697716307L;
    private String name;
    private String description;
    private Subject payer;
    private boolean enabled;
    private TransferType originalTransferType;
    private TransferType generatedTransferType;
    private ChargeType chargeType;
    private BigDecimal value;
    private BigDecimal maxFixedValue;
    private BigDecimal maxPercentageValue;
    private BigDecimal initialAmount;
    private BigDecimal finalAmount;
    private boolean deductAmount;
    private Collection<Transfer> transfers;
    private boolean fromAllGroups = true;
    private Collection<MemberGroup> fromGroups;
    private boolean toAllGroups = true;
    private Collection<MemberGroup> toGroups;
    private Member fromFixedMember;

    public Amount getAmount() {
        if (this.chargeType == null || this.value == null) {
            return null;
        }
        return new Amount(this.value, this.chargeType.toAmountType());
    }

    public ChargeType getChargeType() {
        return this.chargeType;
    }

    public String getDescription() {
        return this.description;
    }

    public BigDecimal getFinalAmount() {
        return this.finalAmount;
    }

    public Member getFromFixedMember() {
        return this.fromFixedMember;
    }

    public Collection<MemberGroup> getFromGroups() {
        return this.fromGroups;
    }

    public TransferType getGeneratedTransferType() {
        return this.generatedTransferType;
    }

    public BigDecimal getInitialAmount() {
        return this.initialAmount;
    }

    public BigDecimal getMaxFixedValue() {
        return this.maxFixedValue;
    }

    public BigDecimal getMaxPercentageValue() {
        return this.maxPercentageValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract Nature getNature();

    public TransferType getOriginalTransferType() {
        return this.originalTransferType;
    }

    public Subject getPayer() {
        return this.payer;
    }

    public Collection<MemberGroup> getToGroups() {
        return this.toGroups;
    }

    public Collection<Transfer> getTransfers() {
        return this.transfers;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public boolean isDeductAmount() {
        return this.deductAmount;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isFromAllGroups() {
        return this.fromAllGroups;
    }

    public boolean isFromMember() {
        return !this.isFromSystem();
    }

    public boolean isFromSystem() {
        return this.generatedTransferType.isFromSystem();
    }

    public boolean isToAllGroups() {
        return this.toAllGroups;
    }

    public void setAmount(Amount amount) {
        if (amount == null) {
            this.value = null;
            this.chargeType = null;
        } else {
            this.value = amount.getValue();
            this.chargeType = ChargeType.from(amount.getType());
        }
    }

    public void setAmountForRates(Amount amount) {
        if (this.chargeType != ChargeType.A_RATE && this.chargeType != ChargeType.D_RATE && this.chargeType != ChargeType.MIXED_A_D_RATES) {
            throw new IllegalArgumentException("TransactionFee.setAmountForRates can only be called in case of a charge type related to A-rate or D-rate.");
        }
        this.value = amount == null ? null : amount.getValue();
    }

    public void setChargeType(ChargeType chargeType) {
        this.chargeType = chargeType;
    }

    public void setDeductAmount(boolean deductAmount) {
        this.deductAmount = deductAmount;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setFinalAmount(BigDecimal finalAmount) {
        this.finalAmount = finalAmount;
    }

    public void setFromAllGroups(boolean fromAllGroups) {
        this.fromAllGroups = fromAllGroups;
    }

    public void setFromFixedMember(Member fromFixedMember) {
        this.fromFixedMember = fromFixedMember;
    }

    public void setFromGroups(Collection<MemberGroup> fromGroups) {
        this.fromGroups = fromGroups;
    }

    public void setGeneratedTransferType(TransferType generatedTransferType) {
        this.generatedTransferType = generatedTransferType;
    }

    public void setInitialAmount(BigDecimal initialAmount) {
        this.initialAmount = initialAmount;
    }

    public void setMaxFixedValue(BigDecimal maxFixedValue) {
        this.maxFixedValue = maxFixedValue;
    }

    public void setMaxPercentageValue(BigDecimal maxPercentageValue) {
        this.maxPercentageValue = maxPercentageValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOriginalTransferType(TransferType originalTransferType) {
        this.originalTransferType = originalTransferType;
    }

    public void setPayer(Subject payer) {
        this.payer = payer;
    }

    public void setToAllGroups(boolean toAllGroups) {
        this.toAllGroups = toAllGroups;
    }

    public void setToGroups(Collection<MemberGroup> toGroups) {
        this.toGroups = toGroups;
    }

    public void setTransfers(Collection<Transfer> transfers) {
        this.transfers = transfers;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum Subject implements StringValuedEnum
    {
        SYSTEM("sys"),
        SOURCE("src"),
        SOURCE_BROKER("sbr"),
        DESTINATION("dst"),
        DESTINATION_BROKER("dbr"),
        FIXED_MEMBER("mem");

        private final String value;

        private Subject(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        GENERATED_TRANSFER_TYPE("generatedTransferType"),
        ORIGINAL_TRANSFER_TYPE("originalTransferType"),
        TRANSFERS("transfers"),
        FROM_GROUPS("fromGroups"),
        TO_GROUPS("toGroups"),
        FROM_FIXED_MEMBER("fromFixedMember");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Nature implements StringValuedEnum
    {
        SIMPLE("S"),
        BROKER("B");

        private final String value;

        private Nature(String value) {
            this.value = value;
        }

        public Class<? extends TransactionFee> getFeeClass() {
            if (this == SIMPLE) {
                return SimpleTransactionFee.class;
            }
            return BrokerCommission.class;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum ChargeType implements StringValuedEnum
    {
        FIXED("F"),
        PERCENTAGE("P"),
        A_RATE("A"),
        D_RATE("D"),
        MIXED_A_D_RATES("M");

        private final String value;

        public static ChargeType from(Amount.Type type) {
            if (type == null) {
                return null;
            }
            switch (type) {
                case FIXED: {
                    return FIXED;
                }
                case PERCENTAGE: {
                    return PERCENTAGE;
                }
            }
            return null;
        }

        private ChargeType(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public Amount.Type toAmountType() {
            switch (this) {
                case FIXED: {
                    return Amount.Type.FIXED;
                }
                case PERCENTAGE: 
                case A_RATE: 
                case D_RATE: 
                case MIXED_A_D_RATES: {
                    return Amount.Type.PERCENTAGE;
                }
            }
            return null;
        }
    }
}

