/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.guarantees;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.CertificationLog;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class Certification
extends Entity {
    private static final long serialVersionUID = -4782899135453104654L;
    private BigDecimal amount;
    private Period validity;
    private Status status;
    private GuaranteeType guaranteeType;
    private Collection<CertificationLog> logs;
    private Member buyer;
    private Member issuer;

    public CertificationLog changeStatus(Status status, Element by) {
        this.setStatus(status);
        if (this.logs == null) {
            this.logs = new ArrayList<CertificationLog>();
        }
        CertificationLog log = this.getNewLog(status, by);
        this.logs.add(log);
        return log;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Member getBuyer() {
        return this.buyer;
    }

    public GuaranteeType getGuaranteeType() {
        return this.guaranteeType;
    }

    public Member getIssuer() {
        return this.issuer;
    }

    public Collection<CertificationLog> getLogs() {
        return this.logs;
    }

    public CertificationLog getNewLog(Status status, Element by) {
        CertificationLog log = new CertificationLog();
        log.setCertification(this);
        log.setDate(Calendar.getInstance());
        log.setStatus(status);
        log.setBy(by);
        return log;
    }

    public Status getStatus() {
        return this.status;
    }

    public Period getValidity() {
        return this.validity;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setBuyer(Member buyer) {
        this.buyer = buyer;
    }

    public void setGuaranteeType(GuaranteeType guaranteeType) {
        this.guaranteeType = guaranteeType;
    }

    public void setIssuer(Member issuer) {
        this.issuer = issuer;
    }

    public void setLogs(Collection<CertificationLog> logs) {
        this.logs = logs;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setValidity(Period validity) {
        this.validity = validity;
    }

    @Override
    public String toString() {
        return "Cert. (" + this.getId() + ") - " + this.status;
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        String pattern = this.getGuaranteeType().getCurrency().getPattern();
        variables.put("amount", localSettings.getUnitsConverter(pattern).toString(this.getAmount()));
        variables.put("buyer_member", this.getBuyer().getName());
        variables.put("buyer_login", this.getBuyer().getUsername());
        variables.put("issuer_member", this.getIssuer().getName());
        variables.put("issuer_login", this.getIssuer().getUsername());
    }

    public static enum Status implements StringValuedEnum
    {
        ACTIVE("A"),
        CANCELLED("C"),
        SUSPENDED("S"),
        EXPIRED("E"),
        SCHEDULED("SC");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        GUARANTEE_TYPE("guaranteeType"),
        LOGS("logs"),
        BUYER("buyer"),
        ISSUER("issuer");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

