/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.guarantees;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeLog;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeFeeVO;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.guarantees.GuaranteesHelper;

public class Guarantee
extends Entity
implements CustomFieldsContainer<PaymentCustomField, PaymentCustomFieldValue> {
    private static final long serialVersionUID = 3906916142405683801L;
    private Status status;
    private BigDecimal amount;
    private GuaranteeFeeVO creditFeeSpec;
    private GuaranteeFeeVO issueFeeSpec;
    private Period validity;
    private Calendar registrationDate;
    private Certification certification;
    private GuaranteeType guaranteeType;
    private Loan loan;
    private Collection<PaymentObligation> paymentObligations;
    private Collection<GuaranteeLog> logs;
    private Member buyer;
    private Member seller;
    private Member issuer;
    private Collection<PaymentCustomFieldValue> customValues;

    public GuaranteeLog changeStatus(Status status, Element by) {
        this.setStatus(status);
        if (this.logs == null) {
            this.logs = new ArrayList<GuaranteeLog>();
        }
        GuaranteeLog log = this.getNewLog(status, by);
        this.logs.add(log);
        return log;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Member getBuyer() {
        return this.buyer;
    }

    public Certification getCertification() {
        return this.certification;
    }

    public BigDecimal getCreditFee() {
        return this.isNullFee(this.creditFeeSpec) ? null : GuaranteesHelper.calculateFee(this.validity, this.amount, this.creditFeeSpec);
    }

    public GuaranteeFeeVO getCreditFeeSpec() {
        return this.creditFeeSpec;
    }

    @Override
    public Class<PaymentCustomField> getCustomFieldClass() {
        return PaymentCustomField.class;
    }

    @Override
    public Class<PaymentCustomFieldValue> getCustomFieldValueClass() {
        return PaymentCustomFieldValue.class;
    }

    @Override
    public Collection<PaymentCustomFieldValue> getCustomValues() {
        return this.customValues;
    }

    public GuaranteeType getGuaranteeType() {
        return this.guaranteeType;
    }

    public BigDecimal getIssueFee() {
        return this.isNullFee(this.issueFeeSpec) ? null : GuaranteesHelper.calculateFee(this.validity, this.amount, this.issueFeeSpec);
    }

    public GuaranteeFeeVO getIssueFeeSpec() {
        return this.issueFeeSpec;
    }

    public Member getIssuer() {
        return this.issuer;
    }

    public Loan getLoan() {
        return this.loan;
    }

    public Collection<GuaranteeLog> getLogs() {
        return this.logs;
    }

    public GuaranteeLog getNewLog(Status status, Element by) {
        GuaranteeLog log = new GuaranteeLog();
        log.setGuarantee(this);
        log.setDate(Calendar.getInstance());
        log.setStatus(status);
        log.setBy(by);
        return log;
    }

    public Collection<PaymentObligation> getPaymentObligations() {
        return this.paymentObligations;
    }

    public Calendar getRegistrationDate() {
        return this.registrationDate;
    }

    public Member getSeller() {
        return this.seller;
    }

    public Status getStatus() {
        return this.status;
    }

    public Period getValidity() {
        return this.validity;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setBuyer(Member buyer) {
        this.buyer = buyer;
    }

    public void setCertification(Certification certification) {
        this.certification = certification;
    }

    public void setCreditFeeSpec(GuaranteeFeeVO creditFeeSpec) {
        this.creditFeeSpec = creditFeeSpec;
    }

    @Override
    public void setCustomValues(Collection<PaymentCustomFieldValue> customValues) {
        this.customValues = customValues;
    }

    public void setGuaranteeType(GuaranteeType guaranteeType) {
        this.guaranteeType = guaranteeType;
    }

    public void setIssueFeeSpec(GuaranteeFeeVO issueFeeSpec) {
        this.issueFeeSpec = issueFeeSpec;
    }

    public void setIssuer(Member issuer) {
        this.issuer = issuer;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    public void setLogs(Collection<GuaranteeLog> logs) {
        this.logs = logs;
    }

    public void setPaymentObligations(Collection<PaymentObligation> paymentObligations) {
        this.paymentObligations = paymentObligations;
    }

    public void setRegistrationDate(Calendar issueDate) {
        this.registrationDate = issueDate;
    }

    public void setSeller(Member seller) {
        this.seller = seller;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setValidity(Period validity) {
        this.validity = validity;
    }

    @Override
    public String toString() {
        return "G: " + this.getId() + " - " + this.status;
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        String pattern = this.getGuaranteeType().getCurrency().getPattern();
        variables.put("amount", localSettings.getUnitsConverter(pattern).toString(this.getAmount()));
        variables.put("buyer_member", this.getBuyer().getName());
        variables.put("buyer_login", this.getBuyer().getUsername());
        if (this.getSeller() != null) {
            variables.put("seller_member", this.getSeller().getName());
            variables.put("seller_login", this.getSeller().getUsername());
        }
        if (this.getIssuer() != null) {
            variables.put("issuer_member", this.getIssuer().getName());
            variables.put("issuer_login", this.getIssuer().getUsername());
        }
    }

    private boolean isNullFee(GuaranteeFeeVO feeSpec) {
        return feeSpec == null || feeSpec.getType() == null || feeSpec.getFee() == null;
    }

    public static enum Status implements StringValuedEnum
    {
        PENDING_ISSUER("PI"),
        PENDING_ADMIN("PA"),
        ACCEPTED("A"),
        REJECTED("R"),
        WITHOUT_ACTION("WA"),
        CANCELLED("C");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        CERTIFICATION("certification"),
        GUARANTEE_TYPE("guaranteeType"),
        LOAN("loan"),
        PAYMENT_OBLIGATIONS("paymentObligations"),
        LOGS("logs"),
        BUYER("buyer"),
        SELLER("seller"),
        ISSUER("issuer"),
        CUSTOM_VALUES("customValues");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

