/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.guarantees;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class GuaranteeQuery
extends QueryParameters {
    private static final long serialVersionUID = 1141777792283895467L;
    private List<Guarantee.Status> statusList;
    private Member issuer;
    private Member buyer;
    private Member seller;
    private Member member;
    private Period startIn;
    private Period endIn;
    private Period registeredIn;
    private BigDecimal amountLowerLimit;
    private BigDecimal amountUpperLimit;
    private GuaranteeType guaranteeType;
    private Collection<GuaranteeType> allowedGuaranteeTypes;
    private Certification certification;
    private LoanFilter loanFilter;
    private Collection<PaymentCustomFieldValue> customValues;
    private Member loggedMember;
    private boolean withBuyerOnly;
    private Collection<MemberGroup> managedMemberGroups;

    public Collection<GuaranteeType> getAllowedGuaranteeTypes() {
        return this.allowedGuaranteeTypes;
    }

    public BigDecimal getAmountLowerLimit() {
        return this.amountLowerLimit;
    }

    public BigDecimal getAmountUpperLimit() {
        return this.amountUpperLimit;
    }

    public Member getBuyer() {
        return this.buyer;
    }

    public Certification getCertification() {
        return this.certification;
    }

    public Collection<PaymentCustomFieldValue> getCustomValues() {
        return this.customValues;
    }

    public Period getEndIn() {
        return this.endIn;
    }

    public GuaranteeType getGuaranteeType() {
        return this.guaranteeType;
    }

    public Member getIssuer() {
        return this.issuer;
    }

    public LoanFilter getLoanFilter() {
        return this.loanFilter;
    }

    public Member getLoggedMember() {
        return this.loggedMember;
    }

    public Collection<MemberGroup> getManagedMemberGroups() {
        return this.managedMemberGroups;
    }

    public Member getMember() {
        return this.member;
    }

    public Period getRegisteredIn() {
        return this.registeredIn;
    }

    public Member getSeller() {
        return this.seller;
    }

    public Period getStartIn() {
        return this.startIn;
    }

    public List<Guarantee.Status> getStatusList() {
        return this.statusList;
    }

    public boolean isWithBuyerOnly() {
        return this.withBuyerOnly;
    }

    public void setAllowedGuaranteeTypes(Collection<GuaranteeType> guaranteeTypes) {
        this.allowedGuaranteeTypes = guaranteeTypes;
    }

    public void setAmountLowerLimit(BigDecimal amountFrom) {
        this.amountLowerLimit = amountFrom;
    }

    public void setAmountUpperLimit(BigDecimal amountTo) {
        this.amountUpperLimit = amountTo;
    }

    public void setBuyer(Member buyer) {
        this.buyer = buyer;
    }

    public void setCertification(Certification certification) {
        this.certification = certification;
    }

    public void setCustomValues(Collection<PaymentCustomFieldValue> customValues) {
        this.customValues = customValues;
    }

    public void setEndIn(Period endIn) {
        this.endIn = endIn;
    }

    public void setGuaranteeType(GuaranteeType guaranteeType) {
        this.guaranteeType = guaranteeType;
    }

    public void setIssuer(Member issuer) {
        this.issuer = issuer;
    }

    public void setLoanFilter(LoanFilter loanFilter) {
        this.loanFilter = loanFilter;
    }

    public void setLoggedMember(Member loggedMember) {
        this.loggedMember = loggedMember;
    }

    public void setManagedMemberGroups(Collection<MemberGroup> groups) {
        this.managedMemberGroups = groups;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void setRegisteredIn(Period registeredIn) {
        this.registeredIn = registeredIn;
    }

    public void setSeller(Member seller) {
        this.seller = seller;
    }

    public void setStartIn(Period startIn) {
        this.startIn = startIn;
    }

    public void setStatusList(List<Guarantee.Status> statusList) {
        this.statusList = statusList;
    }

    public void setWithBuyerOnly(boolean withBuyerOnly) {
        this.withBuyerOnly = withBuyerOnly;
    }

    public static enum LoanFilter {
        WITH_LOAN,
        WITHOUT_LOAN,
        ALL;

    }
}

