/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.guarantees;

import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeFeeVO;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.TimePeriod;

public class GuaranteeType
extends Entity {
    private static final long serialVersionUID = -8522901316173399683L;
    private String name;
    private String description;
    private Model model;
    private AuthorizedBy authorizedBy;
    private boolean enabled;
    private TimePeriod pendingGuaranteeExpiration;
    private TimePeriod paymentObligationPeriod;
    private Currency currency;
    private GuaranteeTypeFeeVO creditFee;
    private GuaranteeTypeFeeVO issueFee;
    private FeePayer creditFeePayer;
    private FeePayer issueFeePayer;
    private TransferType loanTransferType;
    private TransferType creditFeeTransferType;
    private TransferType issueFeeTransferType;
    private TransferType forwardTransferType;

    public AuthorizedBy getAuthorizedBy() {
        return this.authorizedBy;
    }

    public GuaranteeTypeFeeVO getCreditFee() {
        return this.creditFee;
    }

    public FeePayer getCreditFeePayer() {
        return this.creditFeePayer;
    }

    public TransferType getCreditFeeTransferType() {
        return this.creditFeeTransferType;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public TransferType getForwardTransferType() {
        return this.forwardTransferType;
    }

    public GuaranteeTypeFeeVO getIssueFee() {
        return this.issueFee;
    }

    public FeePayer getIssueFeePayer() {
        return this.issueFeePayer;
    }

    public TransferType getIssueFeeTransferType() {
        return this.issueFeeTransferType;
    }

    public TransferType getLoanTransferType() {
        return this.loanTransferType;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TimePeriod getPaymentObligationPeriod() {
        return this.paymentObligationPeriod;
    }

    public TimePeriod getPendingGuaranteeExpiration() {
        return this.pendingGuaranteeExpiration;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setAuthorizedBy(AuthorizedBy authorizedBy) {
        this.authorizedBy = authorizedBy;
    }

    public void setCreditFee(GuaranteeTypeFeeVO creditFee) {
        this.creditFee = creditFee;
    }

    public void setCreditFeePayer(FeePayer creditFeePayer) {
        this.creditFeePayer = creditFeePayer;
    }

    public void setCreditFeeTransferType(TransferType usageFeeTransferType) {
        this.creditFeeTransferType = usageFeeTransferType;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setForwardTransferType(TransferType forwardTransferType) {
        this.forwardTransferType = forwardTransferType;
    }

    public void setIssueFee(GuaranteeTypeFeeVO issueFee) {
        this.issueFee = issueFee;
    }

    public void setIssueFeePayer(FeePayer issueFeePayer) {
        this.issueFeePayer = issueFeePayer;
    }

    public void setIssueFeeTransferType(TransferType issueFeeTransferType) {
        this.issueFeeTransferType = issueFeeTransferType;
    }

    public void setLoanTransferType(TransferType loanTransferType) {
        this.loanTransferType = loanTransferType;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPaymentObligationPeriod(TimePeriod paymentObligationPeriod) {
        this.paymentObligationPeriod = paymentObligationPeriod;
    }

    public void setPendingGuaranteeExpiration(TimePeriod pendingGuaranteeExpiration) {
        this.pendingGuaranteeExpiration = pendingGuaranteeExpiration;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum Relationships implements Relationship
    {
        CURRENCY("currency"),
        LOAN_TRANSFER_TYPE("loanTransferType"),
        CREDIT_FEE_TRANSFER_TYPE("creditFeeTransferType"),
        ISSUE_FEE_TRANSFER_TYPE("issueFeeTransferType"),
        FORWARD_TRANSFER_TYPE("forwardTransferType");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Model implements StringValuedEnum
    {
        WITH_PAYMENT_OBLIGATION("PO"),
        WITH_BUYER_ONLY("BO"),
        WITH_BUYER_AND_SELLER("BS");

        private final String value;

        private Model(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum FeeType implements StringValuedEnum
    {
        FIXED("F"),
        PERCENTAGE("P"),
        VARIABLE_ACCORDING_TO_TIME("V");

        private final String value;

        private FeeType(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum FeePayer implements StringValuedEnum
    {
        BUYER("B"),
        SELLER("S");

        private final String value;

        private FeePayer(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum AuthorizedBy implements StringValuedEnum
    {
        ISSUER("I"),
        ADMIN("A"),
        BOTH("B"),
        NONE("N");

        private final String value;

        private AuthorizedBy(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

