/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.guarantees;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligationLog;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class PaymentObligation
extends Entity {
    private static final long serialVersionUID = -3493507277972263881L;
    private Status status;
    private String description;
    private BigDecimal amount;
    private Calendar expirationDate;
    private Calendar maxPublishDate;
    private Calendar registrationDate;
    private Guarantee guarantee;
    private Currency currency;
    private Collection<PaymentObligationLog> logs;
    private Member buyer;
    private Member seller;

    public PaymentObligationLog changeStatus(Status status, Element by) {
        this.setStatus(status);
        if (this.logs == null) {
            this.logs = new ArrayList<PaymentObligationLog>();
        }
        PaymentObligationLog log = this.getNewLog(status, by);
        this.logs.add(log);
        return log;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Member getBuyer() {
        return this.buyer;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public Guarantee getGuarantee() {
        return this.guarantee;
    }

    public Collection<PaymentObligationLog> getLogs() {
        return this.logs;
    }

    public Calendar getMaxPublishDate() {
        return this.maxPublishDate;
    }

    public PaymentObligationLog getNewLog(Status status, Element by) {
        PaymentObligationLog log = new PaymentObligationLog();
        log.setPaymentObligation(this);
        log.setDate(Calendar.getInstance());
        log.setStatus(status);
        log.setBy(by);
        return log;
    }

    public Calendar getRegistrationDate() {
        return this.registrationDate;
    }

    public Member getSeller() {
        return this.seller;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setBuyer(Member buyer) {
        this.buyer = buyer;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExpirationDate(Calendar expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setGuarantee(Guarantee guarantee) {
        this.guarantee = guarantee;
    }

    public void setLogs(Collection<PaymentObligationLog> logs) {
        this.logs = logs;
    }

    public void setMaxPublishDate(Calendar maxPublishDate) {
        this.maxPublishDate = maxPublishDate;
    }

    public void setRegistrationDate(Calendar registrationDate) {
        this.registrationDate = registrationDate;
    }

    public void setSeller(Member seller) {
        this.seller = seller;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "PO: " + this.getId() + " - " + this.status;
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        String pattern = this.getCurrency().getPattern();
        variables.put("amount", localSettings.getUnitsConverter(pattern).toString(this.getAmount()));
        variables.put("buyer_member", this.getBuyer().getName());
        variables.put("buyer_login", this.getBuyer().getUsername());
        variables.put("seller_member", this.getSeller().getName());
        variables.put("seller_login", this.getSeller().getUsername());
    }

    public static enum Status implements StringValuedEnum
    {
        REGISTERED("RG"),
        PUBLISHED("P"),
        ACCEPTED("A"),
        REJECTED("RJ"),
        EXPIRED("E");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        GUARANTEE("guarantee"),
        CURRENCY("currency"),
        LOGS("logs"),
        BUYER("buyer"),
        SELLER("seller");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

