/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.loans;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class Loan
extends Entity {
    private static final long serialVersionUID = 7890624598546777599L;
    private List<LoanPayment> payments;
    private LoanGroup loanGroup;
    private LoanParameters parameters;
    private Collection<Member> toMembers;
    private BigDecimal totalAmount;
    private Transfer transfer;

    public BigDecimal getAmount() {
        return this.transfer == null ? null : this.transfer.getAmount();
    }

    public int getClosedPaymentsCount() {
        int count = 0;
        for (LoanPayment payment : this.payments) {
            if (!payment.getStatus().isClosed()) continue;
            ++count;
        }
        return count;
    }

    public Calendar getExpirationDate() {
        LoanPayment payment = this.getFirstOpenPayment();
        if (payment == null) {
            payment = this.payments == null || this.payments.isEmpty() ? null : this.payments.get(this.payments.size() - 1);
        }
        return payment == null ? null : payment.getExpirationDate();
    }

    public LoanPayment getFirstOpenPayment() {
        if (this.payments != null) {
            for (LoanPayment payment : this.payments) {
                if (!payment.getStatus().isOpen()) continue;
                return payment;
            }
        }
        return null;
    }

    public LoanPayment getFirstPaymentWithStatus(LoanPayment.Status status) {
        if (this.payments != null) {
            for (LoanPayment payment : this.payments) {
                if (status != payment.getStatus()) continue;
                return payment;
            }
        }
        return null;
    }

    public Calendar getGrantDate() {
        return this.transfer == null ? null : this.transfer.getProcessDate();
    }

    public LoanGroup getLoanGroup() {
        return this.loanGroup;
    }

    public Member getMember() {
        try {
            return (Member)this.transfer.getTo().getOwner();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public LoanParameters getParameters() {
        return this.parameters;
    }

    public int getPaymentCount() {
        return this.payments == null ? 0 : this.payments.size();
    }

    public List<LoanPayment> getPayments() {
        return this.payments;
    }

    public BigDecimal getRemainingAmount() {
        return this.totalAmount.subtract(this.getRepaidAmount());
    }

    public BigDecimal getRepaidAmount() {
        BigDecimal total = BigDecimal.ZERO;
        if (this.payments != null) {
            for (LoanPayment payment : this.payments) {
                LoanPayment.Status status = payment.getStatus();
                if (status.isClosed() && status != LoanPayment.Status.UNRECOVERABLE) {
                    total = total.add(payment.getAmount());
                    continue;
                }
                total = total.add(payment.getRepaidAmount());
            }
        }
        return total;
    }

    public Calendar getRepaymentDate() {
        if (this.payments == null || this.payments.isEmpty()) {
            return null;
        }
        LoanPayment payment = this.payments.get(this.payments.size() - 1);
        return payment.getStatus().isClosed() ? payment.getRepaymentDate() : null;
    }

    public Status getStatus() {
        if (this.transfer.getStatus() == Payment.Status.PENDING) {
            return Status.PENDING_AUTHORIZATION;
        }
        if (this.transfer.getStatus() == Payment.Status.DENIED) {
            return Status.AUTHORIZATION_DENIED;
        }
        for (LoanPayment payment : this.getPayments()) {
            if (!payment.getStatus().isOpen()) continue;
            return Status.OPEN;
        }
        return Status.CLOSED;
    }

    public Collection<Member> getToMembers() {
        return this.toMembers;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public TransferType getTransferType() {
        return this.transfer == null ? null : this.transfer.getType();
    }

    public boolean isToGroup() {
        return this.loanGroup != null;
    }

    public void setLoanGroup(LoanGroup loanGroup) {
        this.loanGroup = loanGroup;
    }

    public void setParameters(LoanParameters parameters) {
        this.parameters = parameters;
    }

    public void setPayments(List<LoanPayment> components) {
        this.payments = components;
    }

    public void setToMembers(Collection<Member> toMembers) {
        this.toMembers = toMembers;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setTransfer(Transfer transfer) {
        this.transfer = transfer;
    }

    @Override
    public String toString() {
        return this.getId() + " - amount: " + FormatObject.formatObject(this.getAmount()) + ", to: " + this.getMember() + ", type: " + this.getTransferType();
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        variables.put("grant_date", localSettings.getDateConverter().toString(this.transfer.getDate()));
        variables.put("amount", localSettings.getUnitsConverter(this.transfer.getTo().getType().getCurrency().getPattern()).toString(this.transfer.getAmount()));
    }

    public static enum Type implements StringValuedEnum
    {
        SINGLE_PAYMENT("S"),
        MULTI_PAYMENT("M"),
        WITH_INTEREST("I");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public boolean allowsPartialRepayments() {
            return this != WITH_INTEREST;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Status implements StringValuedEnum
    {
        OPEN("O"),
        CLOSED("C"),
        PENDING_AUTHORIZATION("P"),
        AUTHORIZATION_DENIED("D");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isClosed() {
            return this == CLOSED;
        }

        public boolean isRelatedToAuthorization() {
            return this == PENDING_AUTHORIZATION || this == AUTHORIZATION_DENIED;
        }
    }

    public static enum Relationships implements Relationship
    {
        PAYMENTS("payments"),
        LOAN_GROUP("loanGroup"),
        TO_MEMBERS("toMembers"),
        TRANSFER("transfer"),
        REPAYMENT_TYPE("parameters.repaymentType");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

