/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.loans;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Calendar;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.DateHelper;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class LoanParameters
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -2308200961589222771L;
    private Loan.Type type;
    private Integer repaymentDays;
    private TransferType repaymentType;
    private BigDecimal monthlyInterest;
    private TransferType monthlyInterestRepaymentType;
    private Amount grantFee;
    private TransferType grantFeeRepaymentType;
    private Amount expirationFee;
    private TransferType expirationFeeRepaymentType;
    private BigDecimal expirationDailyInterest;
    private TransferType expirationDailyInterestRepaymentType;
    private TransferType originalTransferType;

    public BigDecimal calculateGrantFee(BigDecimal amount) {
        if (this.grantFee == null || this.grantFee.getValue() == null || amount.compareTo(BigDecimal.ZERO) != 1) {
            return BigDecimal.ZERO;
        }
        return this.grantFee.apply(amount);
    }

    public BigDecimal calculateLoanTotal(BigDecimal amount, int paymentCount, Calendar grantDate, Calendar firstExpirationDate, MathContext mathContext) {
        BigDecimal grantFee = this.calculateGrantFee(amount);
        BigDecimal monthlyInterests = this.calculateMonthlyInterests(amount, paymentCount, grantDate, firstExpirationDate, mathContext);
        return amount.add(grantFee).add(monthlyInterests);
    }

    public BigDecimal calculateMonthlyInterests(BigDecimal amount, int paymentCount, Calendar grantDate, Calendar firstExpirationDate, MathContext mathContext) {
        if (this.monthlyInterest == null || amount.compareTo(BigDecimal.ZERO) != 1 || paymentCount < 1) {
            return BigDecimal.ZERO;
        }
        Calendar now = Calendar.getInstance();
        grantDate = grantDate == null ? now : grantDate;
        firstExpirationDate = firstExpirationDate == null ? (Calendar)now.clone() : firstExpirationDate;
        Calendar shouldBeFirstExpiration = (Calendar)grantDate.clone();
        shouldBeFirstExpiration.add(2, 1);
        int delay = DateHelper.daysBetween(shouldBeFirstExpiration, firstExpirationDate);
        if (delay < 0) {
            delay = 0;
        }
        BigDecimal grantFee = this.calculateGrantFee(amount);
        BigDecimal baseAmount = amount.add(grantFee);
        BigDecimal interests = this.monthlyInterest.divide(new BigDecimal(100), mathContext);
        BigDecimal numerator = new BigDecimal(Math.pow(1.0 + interests.doubleValue(), (float)paymentCount + (float)delay / 30.0f)).multiply(interests);
        BigDecimal denominator = new BigDecimal(Math.pow(1.0 + interests.doubleValue(), paymentCount) - 1.0);
        BigDecimal paymentAmount = baseAmount.multiply(numerator).divide(denominator, mathContext);
        BigDecimal totalAmount = paymentAmount.multiply(new BigDecimal(paymentCount));
        return totalAmount.subtract(baseAmount);
    }

    public BigDecimal calculatePaymentExpirationFee(BigDecimal amount, int diff) {
        if (this.expirationFee != null && this.expirationFee.getValue() != null && diff > 0) {
            return this.expirationFee.apply(amount);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal calculatePaymentExpirationInterest(BigDecimal amount, int diff, MathContext mathContext) {
        if (this.expirationDailyInterest != null && diff > 0) {
            return this.expirationDailyInterest.multiply(amount).multiply(new BigDecimal(diff)).divide(new BigDecimal(100), mathContext);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal calculatePaymentTotal(BigDecimal amount, Calendar date, Calendar expirationDate, MathContext mathContext) {
        int diff = DateHelper.daysBetween(date, expirationDate);
        return amount.add(this.calculatePaymentExpirationFee(amount, diff)).add(this.calculatePaymentExpirationInterest(amount, diff, mathContext));
    }

    public LoanParameters clone() {
        try {
            return (LoanParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LoanParameters)) {
            return false;
        }
        LoanParameters lp = (LoanParameters)obj;
        EqualsBuilder eb = new EqualsBuilder();
        eb.append((Object)this.type, (Object)lp.type);
        eb.append((Object)this.repaymentType, (Object)lp.repaymentType);
        eb.append((Object)this.grantFee, (Object)lp.grantFee);
        eb.append((Object)this.monthlyInterest, (Object)lp.monthlyInterest);
        eb.append((Object)this.expirationFee, (Object)lp.expirationFee);
        eb.append((Object)this.expirationDailyInterest, (Object)lp.expirationDailyInterest);
        eb.append((Object)this.repaymentDays, (Object)lp.repaymentDays);
        return eb.isEquals();
    }

    public BigDecimal getExpirationDailyInterest() {
        return this.expirationDailyInterest;
    }

    public Amount getExpirationDailyInterestAmount() {
        return this.expirationDailyInterest == null ? null : Amount.percentage(this.expirationDailyInterest);
    }

    public TransferType getExpirationDailyInterestRepaymentType() {
        return this.expirationDailyInterestRepaymentType;
    }

    public Amount getExpirationFee() {
        return this.expirationFee;
    }

    public TransferType getExpirationFeeRepaymentType() {
        return this.expirationFeeRepaymentType;
    }

    public Amount getGrantFee() {
        return this.grantFee;
    }

    public TransferType getGrantFeeRepaymentType() {
        return this.grantFeeRepaymentType;
    }

    public BigDecimal getMonthlyInterest() {
        return this.monthlyInterest;
    }

    public Amount getMonthlyInterestAmount() {
        return this.monthlyInterest == null ? null : Amount.percentage(this.monthlyInterest);
    }

    public TransferType getMonthlyInterestRepaymentType() {
        return this.monthlyInterestRepaymentType;
    }

    public TransferType getOriginalTransferType() {
        return this.originalTransferType;
    }

    public Integer getRepaymentDays() {
        return this.repaymentDays;
    }

    public TransferType getRepaymentType() {
        return this.repaymentType;
    }

    public Loan.Type getType() {
        return this.type;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.type);
        hcb.append((Object)this.repaymentType);
        hcb.append((Object)this.grantFee);
        hcb.append((Object)this.monthlyInterest);
        hcb.append((Object)this.expirationFee);
        hcb.append((Object)this.expirationDailyInterest);
        hcb.append((Object)this.repaymentDays);
        return hcb.toHashCode();
    }

    public void setExpirationDailyInterest(BigDecimal expirationDailyInterests) {
        this.expirationDailyInterest = expirationDailyInterests;
    }

    public void setExpirationDailyInterestRepaymentType(TransferType expirationDailyInterestRepaymentType) {
        this.expirationDailyInterestRepaymentType = expirationDailyInterestRepaymentType;
    }

    public void setExpirationFee(Amount expirationFee) {
        this.expirationFee = expirationFee;
    }

    public void setExpirationFeeRepaymentType(TransferType expirationFeeRepaymentType) {
        this.expirationFeeRepaymentType = expirationFeeRepaymentType;
    }

    public void setGrantFee(Amount grantFee) {
        this.grantFee = grantFee;
    }

    public void setGrantFeeRepaymentType(TransferType grantFeeRepaymentType) {
        this.grantFeeRepaymentType = grantFeeRepaymentType;
    }

    public void setMonthlyInterest(BigDecimal monthlyInterests) {
        this.monthlyInterest = monthlyInterests;
    }

    public void setMonthlyInterestRepaymentType(TransferType monthlyInterestRepaymentType) {
        this.monthlyInterestRepaymentType = monthlyInterestRepaymentType;
    }

    public void setOriginalTransferType(TransferType originalTransferType) {
        this.originalTransferType = originalTransferType;
    }

    public void setRepaymentDays(Integer repaymentDays) {
        this.repaymentDays = repaymentDays;
    }

    public void setRepaymentType(TransferType repaymentType) {
        this.repaymentType = repaymentType;
    }

    public void setType(Loan.Type type) {
        this.type = type;
    }
}

