/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.loans;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class LoanPayment
extends Entity {
    private static final long serialVersionUID = 3972322253540292312L;
    private Calendar expirationDate;
    private int index;
    private Loan loan;
    private BigDecimal repaidAmount = BigDecimal.ZERO;
    private Calendar repaymentDate;
    private Status status = Status.OPEN;
    private Collection<Transfer> transfers;
    private BigDecimal amount;
    private ExternalTransfer externalTransfer;

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getDiscardedAmount() {
        if (this.status != Status.DISCARDED) {
            return BigDecimal.ZERO;
        }
        try {
            return this.amount.subtract(this.repaidAmount);
        }
        catch (NullPointerException e) {
            return BigDecimal.ZERO;
        }
    }

    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public ExternalTransfer getExternalTransfer() {
        return this.externalTransfer;
    }

    public int getIndex() {
        return this.index;
    }

    public Loan getLoan() {
        return this.loan;
    }

    public int getNumber() {
        return this.index + 1;
    }

    public BigDecimal getRemainingAmount() {
        if (this.status == null || this.status.isClosed()) {
            return BigDecimal.ZERO;
        }
        return this.amount.subtract(this.repaidAmount);
    }

    public BigDecimal getRepaidAmount() {
        return this.repaidAmount;
    }

    public Calendar getRepaymentDate() {
        return this.repaymentDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public Collection<Transfer> getTransfers() {
        return this.transfers;
    }

    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    public void setExpirationDate(Calendar expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setExternalTransfer(ExternalTransfer externalTransfer) {
        this.externalTransfer = externalTransfer;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    public void setRepaidAmount(BigDecimal repaidValue) {
        this.repaidAmount = repaidValue;
    }

    public void setRepaymentDate(Calendar repaymentDate) {
        this.repaymentDate = repaymentDate;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTransfers(Collection<Transfer> transfers) {
        this.transfers = transfers;
    }

    @Override
    public String toString() {
        return this.getId() + " - number: " + (this.index + 1) + " of " + this.loan;
    }

    public static enum Status implements StringValuedEnum
    {
        OPEN("O"),
        REPAID("R"),
        DISCARDED("D"),
        EXPIRED("E"),
        IN_PROCESS("P"),
        UNRECOVERABLE("U"),
        RECOVERED("V");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isClosed() {
            return !this.isOpen();
        }

        public boolean isOpen() {
            return this == OPEN || this == EXPIRED || this == IN_PROCESS;
        }
    }

    public static enum Relationships implements Relationship
    {
        LOAN("loan"),
        TRANSFERS("transfers");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

