/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.loans;

import java.math.BigDecimal;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.utils.DataObject;

public class LoanRepaymentAmountsDTO
extends DataObject {
    private static final long serialVersionUID = -2627273648631985684L;
    private LoanPayment loanPayment;
    private BigDecimal remainingAmountAtExpirationDate;
    private BigDecimal remainingAmountAtDate;

    public BigDecimal getDiscount() {
        BigDecimal diff = this.remainingAmountAtExpirationDate.subtract(this.remainingAmountAtDate);
        if (diff.doubleValue() > 0.001) {
            return diff;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getInterest() {
        BigDecimal diff = this.remainingAmountAtDate.subtract(this.remainingAmountAtExpirationDate);
        if (diff.doubleValue() > 0.001) {
            return diff;
        }
        return BigDecimal.ZERO;
    }

    public LoanPayment getLoanPayment() {
        return this.loanPayment;
    }

    public BigDecimal getRemainingAmountAtDate() {
        return this.remainingAmountAtDate;
    }

    public BigDecimal getRemainingAmountAtExpirationDate() {
        return this.remainingAmountAtExpirationDate;
    }

    public BigDecimal getTotalAmount() {
        BigDecimal repaidAmount = this.loanPayment.getRepaidAmount();
        return (repaidAmount == null ? BigDecimal.ZERO : repaidAmount).add(this.remainingAmountAtDate);
    }

    public void setLoanPayment(LoanPayment payment) {
        this.loanPayment = payment;
    }

    public void setRemainingAmountAtDate(BigDecimal remainingAmountToday) {
        this.remainingAmountAtDate = remainingAmountToday;
    }

    public void setRemainingAmountAtExpirationDate(BigDecimal remainingAmountAtExpirationDate) {
        this.remainingAmountAtExpirationDate = remainingAmountAtExpirationDate;
    }
}

