/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoicePayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class Invoice
extends Entity
implements CustomFieldsContainer<PaymentCustomField, PaymentCustomFieldValue> {
    private static final long serialVersionUID = -2221939158739233962L;
    private AccountFeeLog accountFeeLog;
    private Calendar date;
    private String description;
    private AccountType destinationAccountType;
    private Member fromMember;
    private Status status = Status.OPEN;
    private Member toMember;
    private TransferType transferType;
    private Transfer transfer;
    private BigDecimal amount;
    private Element sentBy;
    private Element performedBy;
    private List<InvoicePayment> payments;
    private ScheduledPayment scheduledPayment;
    private Collection<PaymentCustomFieldValue> customValues;

    public AccountFeeLog getAccountFeeLog() {
        return this.accountFeeLog;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public Class<PaymentCustomField> getCustomFieldClass() {
        return PaymentCustomField.class;
    }

    @Override
    public Class<PaymentCustomFieldValue> getCustomFieldValueClass() {
        return PaymentCustomFieldValue.class;
    }

    @Override
    public Collection<PaymentCustomFieldValue> getCustomValues() {
        return this.customValues;
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public AccountType getDestinationAccountType() {
        return this.destinationAccountType;
    }

    public AccountOwner getFrom() {
        return (AccountOwner)((Object)(this.isFromSystem() ? SystemAccountOwner.instance() : this.fromMember));
    }

    public Member getFromMember() {
        return this.fromMember;
    }

    public Payment getPayment() {
        if (this.transfer == null) {
            return this.scheduledPayment;
        }
        return this.transfer;
    }

    public List<InvoicePayment> getPayments() {
        return this.payments;
    }

    public Element getPerformedBy() {
        return this.performedBy;
    }

    public ScheduledPayment getScheduledPayment() {
        return this.scheduledPayment;
    }

    public Element getSentBy() {
        return this.sentBy;
    }

    public Status getStatus() {
        return this.status;
    }

    public AccountOwner getTo() {
        return (AccountOwner)((Object)(this.isToSystem() ? SystemAccountOwner.instance() : this.toMember));
    }

    public Member getToMember() {
        return this.toMember;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public boolean isFromSystem() {
        return this.fromMember == null;
    }

    public boolean isOpen() {
        return this.status == Status.OPEN;
    }

    public boolean isToSystem() {
        return this.toMember == null;
    }

    public void setAccountFeeLog(AccountFeeLog taxLog) {
        this.accountFeeLog = taxLog;
    }

    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    @Override
    public void setCustomValues(Collection<PaymentCustomFieldValue> customValues) {
        this.customValues = customValues;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDestinationAccountType(AccountType destinationAccountType) {
        this.destinationAccountType = destinationAccountType;
    }

    public void setFrom(AccountOwner owner) {
        this.fromMember = owner instanceof Member ? (Member)owner : null;
    }

    public void setFromMember(Member fromMember) {
        this.fromMember = fromMember;
    }

    public void setPayment(Payment payment) {
        if (payment instanceof Transfer) {
            this.setTransfer((Transfer)payment);
        } else {
            this.setScheduledPayment((ScheduledPayment)payment);
        }
    }

    public void setPayments(List<InvoicePayment> payments) {
        this.payments = payments;
    }

    public void setPerformedBy(Element performedBy) {
        this.performedBy = performedBy;
    }

    public void setScheduledPayment(ScheduledPayment scheduledPayment) {
        this.scheduledPayment = scheduledPayment;
    }

    public void setSentBy(Element sentBy) {
        this.sentBy = sentBy;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTo(AccountOwner owner) {
        this.toMember = owner instanceof Member ? (Member)owner : null;
    }

    public void setToMember(Member toMember) {
        this.toMember = toMember;
    }

    public void setTransfer(Transfer transfer) {
        this.transfer = transfer;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    @Override
    public String toString() {
        return this.getId() + " - amount: " + FormatObject.formatObject(this.amount) + ", from: " + this.getFrom() + ", to: " + this.getTo();
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        if (this.destinationAccountType == null) {
            variables.put("amount", localSettings.getNumberConverter().toString(this.amount));
        } else {
            variables.put("amount", localSettings.getUnitsConverter(this.destinationAccountType.getCurrency().getPattern()).toString(this.amount));
        }
        variables.put("date", localSettings.getDateConverter().toString(this.date));
        variables.put("description", this.description);
        variables.put("desc", this.description);
    }

    public static enum Status implements StringValuedEnum
    {
        OPEN("O"),
        ACCEPTED("A"),
        DENIED("D"),
        CANCELLED("C"),
        EXPIRED("E");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        ACCOUNT_FEE_LOG("accountFeeLog"),
        DESTINATION_ACCOUNT_TYPE("destinationAccountType"),
        FROM_MEMBER("fromMember"),
        TO_MEMBER("toMember"),
        SENT_BY("sentBy"),
        PERFORMED_BY("performedBy"),
        TRANSFER_TYPE("transferType"),
        TRANSFER("transfer"),
        PAYMENTS("payments"),
        SCHEDULED_PAYMENT("scheduledPayment"),
        CUSTOM_VALUES("customValues");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

