/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public abstract class Payment
extends Entity
implements CustomFieldsContainer<PaymentCustomField, PaymentCustomFieldValue> {
    private static final long serialVersionUID = -3197630501722484236L;
    private Calendar date;
    private Calendar transactionFeedbackDeadline;
    private BigDecimal amount;
    private String description;
    private Account from;
    private Account to;
    private TransferType type;
    private Element by;
    private Calendar processDate;
    private Status status = Status.PROCESSED;
    private Collection<PaymentCustomFieldValue> customValues;

    public BigDecimal getActualAmount() {
        BigDecimal amount = this.getAmount();
        return amount == null ? null : amount.abs();
    }

    public abstract Calendar getActualDate();

    public abstract Account getActualFrom();

    public abstract AccountOwner getActualFromOwner();

    public abstract Account getActualTo();

    public abstract AccountOwner getActualToOwner();

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Element getBy() {
        return this.by;
    }

    @Override
    public Class<PaymentCustomField> getCustomFieldClass() {
        return PaymentCustomField.class;
    }

    @Override
    public Class<PaymentCustomFieldValue> getCustomFieldValueClass() {
        return PaymentCustomFieldValue.class;
    }

    @Override
    public Collection<PaymentCustomFieldValue> getCustomValues() {
        return this.customValues;
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public Account getFrom() {
        return this.from;
    }

    public AccountOwner getFromOwner() {
        return this.from.getOwner();
    }

    public abstract Nature getNature();

    public Calendar getProcessDate() {
        return this.processDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public Account getTo() {
        return this.to;
    }

    public AccountOwner getToOwner() {
        return this.to.getOwner();
    }

    public Calendar getTransactionFeedbackDeadline() {
        return this.transactionFeedbackDeadline;
    }

    public TransferType getType() {
        return this.type;
    }

    public boolean isFromSystem() {
        return this.getFromOwner() instanceof SystemAccountOwner;
    }

    public boolean isToSystem() {
        return this.getToOwner() instanceof SystemAccountOwner;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setBy(Element by) {
        this.by = by;
    }

    @Override
    public void setCustomValues(Collection<PaymentCustomFieldValue> customValues) {
        this.customValues = customValues;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFrom(Account from) {
        this.from = from;
    }

    public void setProcessDate(Calendar processDate) {
        this.processDate = processDate;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTo(Account to) {
        this.to = to;
    }

    public void setTransactionFeedbackDeadline(Calendar transactionFeedbackDeadline) {
        this.transactionFeedbackDeadline = transactionFeedbackDeadline;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return this.getId() + " - amount: " + FormatObject.formatObject(this.getAmount()) + ", from: " + this.getFrom() + ", to: " + this.getTo() + ", type: " + this.getType();
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        String toAccountName;
        String fromAccountName;
        String typeName;
        try {
            typeName = this.getType().getName();
        }
        catch (Exception e) {
            typeName = "";
        }
        variables.put("payment_type", typeName);
        try {
            fromAccountName = this.getFrom().getType().getName();
        }
        catch (Exception e) {
            fromAccountName = "";
        }
        if (this.from.getOwner() instanceof Member) {
            Member fromMember = (Member)this.from.getOwner();
            variables.put("from_member", fromMember.getName());
            variables.put("from_login", fromMember.getUsername());
        }
        if (this.to.getOwner() instanceof Member) {
            Member toMember = (Member)this.to.getOwner();
            variables.put("to_member", toMember.getName());
            variables.put("to_login", toMember.getUsername());
        }
        variables.put("from_account", fromAccountName);
        try {
            toAccountName = this.getTo().getType().getName();
        }
        catch (Exception e) {
            toAccountName = "";
        }
        variables.put("to_account", toAccountName);
        try {
            variables.put("amount", localSettings.getUnitsConverter(this.getTo().getType().getCurrency().getPattern()).toString(this.getAmount()));
        }
        catch (Exception e) {
            variables.put("amount", localSettings.getNumberConverter().toString(this.getAmount()));
        }
        variables.put("date", localSettings.getDateConverter().toString(this.getDate()));
        variables.put("description", this.getDescription());
    }

    public static enum Status implements StringValuedEnum
    {
        PENDING("P"),
        PROCESSED("O"),
        DENIED("D"),
        CANCELED("C"),
        SCHEDULED("S"),
        FAILED("F"),
        BLOCKED("B");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public boolean canPayNow() {
            switch (this) {
                case BLOCKED: 
                case FAILED: 
                case SCHEDULED: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        FROM("from"),
        TO("to"),
        BY("by"),
        TYPE("type"),
        CUSTOM_VALUES("customValues");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Nature {
        TRANSFER,
        SCHEDULED_PAYMENT;

    }
}

