/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;

public class ScheduledPayment
extends Payment {
    private static final long serialVersionUID = 7335050802424888764L;
    private boolean reserveAmount;
    private boolean showToReceiver;
    private List<Transfer> transfers;

    @Override
    public Calendar getActualDate() {
        Calendar actualDate = null;
        Calendar lastDate = null;
        for (Transfer transfer : this.transfers) {
            lastDate = transfer.getDate();
            if (transfer.getProcessDate() != null) continue;
            actualDate = transfer.getDate();
            break;
        }
        return actualDate != null ? actualDate : lastDate;
    }

    @Override
    public Account getActualFrom() {
        return this.getFrom();
    }

    @Override
    public AccountOwner getActualFromOwner() {
        return this.getFromOwner();
    }

    @Override
    public Account getActualTo() {
        return this.getTo();
    }

    @Override
    public AccountOwner getActualToOwner() {
        return this.getToOwner();
    }

    public Integer getFirstOpenPaymentIndex() {
        int index = 0;
        for (Transfer transfer : this.transfers) {
            ++index;
            if (transfer.getProcessDate() != null) continue;
            break;
        }
        return index > 0 ? Integer.valueOf(index) : null;
    }

    public Transfer getFirstOpenTransfer() {
        Transfer firstOpenPayment = null;
        for (Transfer transfer : this.transfers) {
            if (transfer.getProcessDate() != null) continue;
            firstOpenPayment = transfer;
            break;
        }
        return firstOpenPayment;
    }

    @Override
    public Payment.Nature getNature() {
        return Payment.Nature.SCHEDULED_PAYMENT;
    }

    public int getNumberOfParcels() {
        return this.transfers.size();
    }

    public BigDecimal getProcessedPaymentAmount() {
        BigDecimal total = new BigDecimal(0);
        for (Transfer transfer : this.transfers) {
            if (transfer.getProcessDate() == null) continue;
            total = total.add(transfer.getAmount());
        }
        return total;
    }

    public int getProcessedPaymentCount() {
        int count = 0;
        for (Transfer transfer : this.transfers) {
            if (transfer.getProcessDate() == null) continue;
            ++count;
        }
        return count;
    }

    public List<Transfer> getTransfers() {
        return this.transfers;
    }

    public boolean isReserveAmount() {
        return this.reserveAmount;
    }

    public boolean isShowToReceiver() {
        return this.showToReceiver;
    }

    public void setReserveAmount(boolean reserveAmount) {
        this.reserveAmount = reserveAmount;
    }

    public void setShowToReceiver(boolean showToReceiver) {
        this.showToReceiver = showToReceiver;
    }

    public void setTransfers(List<Transfer> transfers) {
        this.transfers = transfers;
    }

    public static enum Relationships implements Relationship
    {
        TRANSFERS("transfers");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

